/// <reference path="./internal_*.d.ts" />
declare namespace io.github.fabricators_of_create.porting_lib.models.generators.block {
    abstract class BlockStateProvider implements Internal.DataProvider {
        constructor(output: Internal.PackOutput_, modid: string, exFileHelper: Internal.ExistingFileHelper_)
        horizontalFaceBlock(block: Internal.Block_, modelFunc: Internal.Function_<Internal.BlockState, Internal.ModelFile>): void;
        fenceGateBlockWithRenderType(block: Internal.FenceGateBlock_, name: string, texture: ResourceLocation_, renderType: ResourceLocation_): void;
        itemModels(): Internal.ItemModelProvider;
        directionalBlock(block: Internal.Block_, model: Internal.ModelFile_): void;
        fenceBlock(block: Internal.FenceBlock_, texture: ResourceLocation_): void;
        static saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
        signBlock(signBlock: Internal.StandingSignBlock_, wallSignBlock: Internal.WallSignBlock_, texture: ResourceLocation_): void;
        cubeAll(block: Internal.Block_): Internal.ModelFile;
        stairsBlockWithRenderType(block: Internal.StairBlock_, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_, renderType: string): void;
        axisBlock(block: Internal.RotatedPillarBlock_, baseName: ResourceLocation_): void;
        slabBlock(block: Internal.SlabBlock_, doubleslab: ResourceLocation_, texture: ResourceLocation_): void;
        axisBlock(block: Internal.RotatedPillarBlock_, side: ResourceLocation_, end: ResourceLocation_): void;
        horizontalFaceBlock(block: Internal.Block_, model: Internal.ModelFile_): void;
        stairsBlock(block: Internal.StairBlock_, texture: ResourceLocation_): void;
        horizontalFaceBlock(block: Internal.Block_, modelFunc: Internal.Function_<Internal.BlockState, Internal.ModelFile>, angleOffset: number): void;
        trapdoorBlock(block: Internal.TrapDoorBlock_, texture: ResourceLocation_, orientable: boolean): void;
        directionalBlock(block: Internal.Block_, modelFunc: Internal.Function_<Internal.BlockState, Internal.ModelFile>, angleOffset: number): void;
        mcLoc(name: string): ResourceLocation;
        fenceGateBlock(block: Internal.FenceGateBlock_, texture: ResourceLocation_): void;
        paneBlockWithRenderType(block: Internal.IronBarsBlock_, name: string, pane: ResourceLocation_, edge: ResourceLocation_, renderType: string): void;
        fourWayMultipart(builder: Internal.MultiPartBlockStateBuilder_, side: Internal.ModelFile_): void;
        paneBlock(block: Internal.IronBarsBlock_, pane: ResourceLocation_, edge: ResourceLocation_): void;
        wallBlock(block: Internal.WallBlock_, texture: ResourceLocation_): void;
        stairsBlock(block: Internal.StairBlock_, name: string, texture: ResourceLocation_): void;
        trapdoorBlockWithRenderType(block: Internal.TrapDoorBlock_, name: string, texture: ResourceLocation_, orientable: boolean, renderType: ResourceLocation_): void;
        fenceGateBlockWithRenderType(block: Internal.FenceGateBlock_, name: string, texture: ResourceLocation_, renderType: string): void;
        fenceBlockWithRenderType(block: Internal.FenceBlock_, texture: ResourceLocation_, renderType: ResourceLocation_): void;
        trapdoorBlock(block: Internal.TrapDoorBlock_, bottom: Internal.ModelFile_, top: Internal.ModelFile_, open: Internal.ModelFile_, orientable: boolean): void;
        wallBlockWithRenderType(block: Internal.WallBlock_, texture: ResourceLocation_, renderType: ResourceLocation_): void;
        directionalBlock(block: Internal.Block_, modelFunc: Internal.Function_<Internal.BlockState, Internal.ModelFile>): void;
        axisBlockWithRenderType(block: Internal.RotatedPillarBlock_, renderType: string): void;
        wallBlock(block: Internal.WallBlock_, post: Internal.ModelFile_, side: Internal.ModelFile_, sideTall: Internal.ModelFile_): void;
        simpleBlockWithItem(block: Internal.Block_, model: Internal.ModelFile_): void;
        fourWayBlock(block: Internal.CrossCollisionBlock_, post: Internal.ModelFile_, side: Internal.ModelFile_): void;
        stairsBlockWithRenderType(block: Internal.StairBlock_, name: string, texture: ResourceLocation_, renderType: string): void;
        fenceGateBlock(block: Internal.FenceGateBlock_, gate: Internal.ModelFile_, gateOpen: Internal.ModelFile_, gateWall: Internal.ModelFile_, gateWallOpen: Internal.ModelFile_): void;
        pressurePlateBlock(block: Internal.PressurePlateBlock_, pressurePlate: Internal.ModelFile_, pressurePlateDown: Internal.ModelFile_): void;
        signBlock(signBlock: Internal.StandingSignBlock_, wallSignBlock: Internal.WallSignBlock_, sign: Internal.ModelFile_): void;
        axisBlockWithRenderType(block: Internal.RotatedPillarBlock_, side: ResourceLocation_, end: ResourceLocation_, renderType: string): void;
        getName(): string;
        horizontalBlock(block: Internal.Block_, modelFunc: Internal.Function_<Internal.BlockState, Internal.ModelFile>, angleOffset: number): void;
        stairsBlockWithRenderType(block: Internal.StairBlock_, texture: ResourceLocation_, renderType: string): void;
        slabBlock(block: Internal.SlabBlock_, doubleslab: ResourceLocation_, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_): void;
        fenceBlockWithRenderType(block: Internal.FenceBlock_, texture: ResourceLocation_, renderType: string): void;
        paneBlockWithRenderType(block: Internal.IronBarsBlock_, name: string, pane: ResourceLocation_, edge: ResourceLocation_, renderType: ResourceLocation_): void;
        slabBlock(block: Internal.SlabBlock_, bottom: Internal.ModelFile_, top: Internal.ModelFile_, doubleslab: Internal.ModelFile_): void;
        stairsBlockWithRenderType(block: Internal.StairBlock_, name: string, texture: ResourceLocation_, renderType: ResourceLocation_): void;
        paneBlockWithRenderType(block: Internal.IronBarsBlock_, pane: ResourceLocation_, edge: ResourceLocation_, renderType: string): void;
        blockTexture(block: Internal.Block_): ResourceLocation;
        run(cache: Internal.CachedOutput_): Internal.CompletableFuture<any>;
        wallBlockWithRenderType(block: Internal.WallBlock_, name: string, texture: ResourceLocation_, renderType: ResourceLocation_): void;
        simpleBlock(block: Internal.Block_, expander: Internal.Function_<Internal.ModelFile, Internal.ConfiguredModel[]>): void;
        simpleBlock(block: Internal.Block_, ...models: Internal.ConfiguredModel_[]): void;
        paneBlock(block: Internal.IronBarsBlock_, name: string, pane: ResourceLocation_, edge: ResourceLocation_): void;
        pressurePlateBlock(block: Internal.PressurePlateBlock_, texture: ResourceLocation_): void;
        wallBlockWithRenderType(block: Internal.WallBlock_, texture: ResourceLocation_, renderType: string): void;
        fenceBlockWithRenderType(block: Internal.FenceBlock_, name: string, texture: ResourceLocation_, renderType: string): void;
        horizontalBlock(block: Internal.Block_, modelFunc: Internal.Function_<Internal.BlockState, Internal.ModelFile>): void;
        horizontalBlock(block: Internal.Block_, model: Internal.ModelFile_): void;
        logBlock(block: Internal.RotatedPillarBlock_): void;
        getMultipartBuilder(b: Internal.Block_): Internal.MultiPartBlockStateBuilder;
        fenceBlock(block: Internal.FenceBlock_, name: string, texture: ResourceLocation_): void;
        trapdoorBlockWithRenderType(block: Internal.TrapDoorBlock_, texture: ResourceLocation_, orientable: boolean, renderType: ResourceLocation_): void;
        wallBlock(block: Internal.WallBlock_, name: string, texture: ResourceLocation_): void;
        fenceGateBlock(block: Internal.FenceGateBlock_, name: string, texture: ResourceLocation_): void;
        buttonBlock(block: Internal.ButtonBlock_, button: Internal.ModelFile_, buttonPressed: Internal.ModelFile_): void;
        axisBlock(block: Internal.RotatedPillarBlock_): void;
        stairsBlockWithRenderType(block: Internal.StairBlock_, name: string, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_, renderType: string): void;
        axisBlockWithRenderType(block: Internal.RotatedPillarBlock_, baseName: ResourceLocation_, renderType: ResourceLocation_): void;
        modLoc(name: string): ResourceLocation;
        axisBlockWithRenderType(block: Internal.RotatedPillarBlock_, side: ResourceLocation_, end: ResourceLocation_, renderType: ResourceLocation_): void;
        doorBlock(block: Internal.DoorBlock_, bottomLeft: Internal.ModelFile_, bottomLeftOpen: Internal.ModelFile_, bottomRight: Internal.ModelFile_, bottomRightOpen: Internal.ModelFile_, topLeft: Internal.ModelFile_, topLeftOpen: Internal.ModelFile_, topRight: Internal.ModelFile_, topRightOpen: Internal.ModelFile_): void;
        getVariantBuilder(b: Internal.Block_): Internal.VariantBlockStateBuilder;
        paneBlockWithRenderType(block: Internal.IronBarsBlock_, pane: ResourceLocation_, edge: ResourceLocation_, renderType: ResourceLocation_): void;
        doorBlock(block: Internal.DoorBlock_, bottom: ResourceLocation_, top: ResourceLocation_): void;
        stairsBlock(block: Internal.StairBlock_, name: string, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_): void;
        fenceGateBlockWithRenderType(block: Internal.FenceGateBlock_, texture: ResourceLocation_, renderType: string): void;
        fenceBlockWithRenderType(block: Internal.FenceBlock_, name: string, texture: ResourceLocation_, renderType: ResourceLocation_): void;
        doorBlockWithRenderType(block: Internal.DoorBlock_, name: string, bottom: ResourceLocation_, top: ResourceLocation_, renderType: string): void;
        stairsBlockWithRenderType(block: Internal.StairBlock_, name: string, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_, renderType: ResourceLocation_): void;
        doorBlockWithRenderType(block: Internal.DoorBlock_, bottom: ResourceLocation_, top: ResourceLocation_, renderType: string): void;
        axisBlockWithRenderType(block: Internal.RotatedPillarBlock_, baseName: ResourceLocation_, renderType: string): void;
        axisBlockWithRenderType(block: Internal.RotatedPillarBlock_, renderType: ResourceLocation_): void;
        logBlockWithRenderType(block: Internal.RotatedPillarBlock_, renderType: string): void;
        stairsBlockWithRenderType(block: Internal.StairBlock_, texture: ResourceLocation_, renderType: ResourceLocation_): void;
        stairsBlock(block: Internal.StairBlock_, stairs: Internal.ModelFile_, stairsInner: Internal.ModelFile_, stairsOuter: Internal.ModelFile_): void;
        stairsBlock(block: Internal.StairBlock_, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_): void;
        horizontalBlock(block: Internal.Block_, model: Internal.ModelFile_, angleOffset: number): void;
        logBlockWithRenderType(block: Internal.RotatedPillarBlock_, renderType: ResourceLocation_): void;
        axisBlock(block: Internal.RotatedPillarBlock_, vertical: Internal.ModelFile_, horizontal: Internal.ModelFile_): void;
        trapdoorBlockWithRenderType(block: Internal.TrapDoorBlock_, texture: ResourceLocation_, orientable: boolean, renderType: string): void;
        wallBlockWithRenderType(block: Internal.WallBlock_, name: string, texture: ResourceLocation_, renderType: string): void;
        directionalBlock(block: Internal.Block_, model: Internal.ModelFile_, angleOffset: number): void;
        stairsBlockWithRenderType(block: Internal.StairBlock_, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_, renderType: ResourceLocation_): void;
        horizontalBlock(block: Internal.Block_, side: ResourceLocation_, front: ResourceLocation_, top: ResourceLocation_): void;
        doorBlock(block: Internal.DoorBlock_, name: string, bottom: ResourceLocation_, top: ResourceLocation_): void;
        paneBlock(block: Internal.IronBarsBlock_, post: Internal.ModelFile_, side: Internal.ModelFile_, sideAlt: Internal.ModelFile_, noSide: Internal.ModelFile_, noSideAlt: Internal.ModelFile_): void;
        simpleBlock(block: Internal.Block_, model: Internal.ModelFile_): void;
        trapdoorBlock(block: Internal.TrapDoorBlock_, name: string, texture: ResourceLocation_, orientable: boolean): void;
        doorBlockWithRenderType(block: Internal.DoorBlock_, bottom: ResourceLocation_, top: ResourceLocation_, renderType: ResourceLocation_): void;
        buttonBlock(block: Internal.ButtonBlock_, texture: ResourceLocation_): void;
        trapdoorBlockWithRenderType(block: Internal.TrapDoorBlock_, name: string, texture: ResourceLocation_, orientable: boolean, renderType: string): void;
        doorBlockWithRenderType(block: Internal.DoorBlock_, name: string, bottom: ResourceLocation_, top: ResourceLocation_, renderType: ResourceLocation_): void;
        simpleBlockItem(block: Internal.Block_, model: Internal.ModelFile_): void;
        simpleBlock(block: Internal.Block_): void;
        fenceGateBlockWithRenderType(block: Internal.FenceGateBlock_, texture: ResourceLocation_, renderType: ResourceLocation_): void;
        models(): Internal.BlockModelProvider;
        horizontalFaceBlock(block: Internal.Block_, model: Internal.ModelFile_, angleOffset: number): void;
        get name(): string
        static readonly WALL_PROPS: {[key: Internal.Direction]: Internal.EnumProperty<any>, [key: Internal.Direction]: Internal.EnumProperty<any>, [key: Internal.Direction]: Internal.EnumProperty<any>, [key: Internal.Direction]: Internal.EnumProperty<any>};
    }
    type BlockStateProvider_ = BlockStateProvider;
}
declare namespace Internal {
    class WirelessAccessPointBlock extends Internal.AEBaseEntityBlock<any> implements Internal.SimpleWaterloggedBlock {
        constructor()
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly STATE: Internal.EnumProperty<Internal.WirelessAccessPointBlock$State>;
    }
    type WirelessAccessPointBlock_ = WirelessAccessPointBlock;
    class ConnectorType extends Internal.Enum<Internal.ConnectorType> {
        static valueOf(name: string): Internal.ConnectorType;
        static values(): Internal.ConnectorType[];
        readonly name: string;
        static readonly Small: Internal.ConnectorType;
        static readonly Large: Internal.ConnectorType;
    }
    type ConnectorType_ = "large" | ConnectorType | "small";
    class FurnatorBlock extends Internal.AbstractGeneratorBlock<Internal.FurnatorBlock> implements Internal.SimpleWaterloggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, variant: owmii.powah.block.Tier_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockItem(arg0: Internal.Item$Properties_, arg1: Internal.ResourceKey_<any>): Internal.ItemBlock<any, any>;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getConfig(): Internal.GeneratorConfig;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get config(): Internal.GeneratorConfig
    }
    type FurnatorBlock_ = FurnatorBlock;
    class RecipeCategory extends Internal.Enum<Internal.RecipeCategory> {
        static values(): Internal.RecipeCategory[];
        static valueOf($$0: string): Internal.RecipeCategory;
        getFolderName(): string;
        get folderName(): string
        static readonly BREWING: Internal.RecipeCategory;
        static readonly TRANSPORTATION: Internal.RecipeCategory;
        static readonly DECORATIONS: Internal.RecipeCategory;
        static readonly BUILDING_BLOCKS: Internal.RecipeCategory;
        static readonly TOOLS: Internal.RecipeCategory;
        static readonly FOOD: Internal.RecipeCategory;
        static readonly MISC: Internal.RecipeCategory;
        static readonly COMBAT: Internal.RecipeCategory;
        static readonly REDSTONE: Internal.RecipeCategory;
    }
    type RecipeCategory_ = "transportation" | "misc" | "combat" | "food" | RecipeCategory | "decorations" | "redstone" | "brewing" | "building_blocks" | "tools";
    class Transfer extends Internal.Enum<Internal.Transfer> {
        getDisplayName(): net.minecraft.network.chat.Component;
        getDisplayName2(): net.minecraft.network.chat.Component;
        static values(): Internal.Transfer[];
        next(type: Internal.Transfer_): this;
        static valueOf(name: string): Internal.Transfer;
        get displayName(): net.minecraft.network.chat.Component
        get displayName2(): net.minecraft.network.chat.Component
        static readonly NONE: Internal.Transfer;
        static readonly RECEIVE: Internal.Transfer;
        static readonly ALL: Internal.Transfer;
        static readonly EXTRACT: Internal.Transfer;
        readonly canReceive: boolean;
        readonly canExtract: boolean;
    }
    type Transfer_ = "receive" | Transfer | "extract" | "none" | "all";
    class MahoganyTreeFeature extends Internal.BOPTreeFeature<any> {
        constructor(codec: Internal.Codec_<any>)
    }
    type MahoganyTreeFeature_ = MahoganyTreeFeature;
    class WeepingVinesFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static placeWeepingVinesColumn($$0: Internal.LevelAccessor_, $$1: Internal.RandomSource_, $$2: Internal.BlockPos$MutableBlockPos_, $$3: number, $$4: number, $$5: number): void;
    }
    type WeepingVinesFeature_ = WeepingVinesFeature;
    class CraftingBlockItem extends Internal.AEBaseBlockItem {
        constructor(id: Internal.Block_, props: Internal.Item$Properties_, disassemblyExtra: Internal.Supplier_<Internal.ItemLike>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CraftingBlockItem_ = CraftingBlockItem;
    abstract class QuantumBaseBlock extends Internal.AEBaseEntityBlock<any> implements Internal.SimpleWaterloggedBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly FORMED: Internal.BooleanProperty;
    }
    type QuantumBaseBlock_ = QuantumBaseBlock;
    class PowerMultiplier extends Internal.Enum<Internal.PowerMultiplier> {
        multiply(in_: number): number;
        static valueOf(name: string): Internal.PowerMultiplier;
        divide(in_: number): number;
        static values(): Internal.PowerMultiplier[];
        static readonly CONFIG: Internal.PowerMultiplier;
        static readonly ONE: Internal.PowerMultiplier;
        multiplier: number;
    }
    type PowerMultiplier_ = "config" | PowerMultiplier | "one";
    interface EntityModelSetAccessor {
        abstract getRoots(): Internal.Map<Internal.ModelLayerLocation, Internal.LayerDefinition>;
        abstract setRoots(arg0: Internal.Map_<Internal.ModelLayerLocation, Internal.LayerDefinition>): void;
        get roots(): Internal.Map<Internal.ModelLayerLocation, Internal.LayerDefinition>
        set roots(arg0: Internal.Map_<Internal.ModelLayerLocation, Internal.LayerDefinition>)
    }
    type EntityModelSetAccessor_ = EntityModelSetAccessor;
    class ChestMenuSlot {
        constructor(gui: Internal.ChestMenuData_, index: number)
        resetClickHandlers(): void;
        setThrown(callback: Internal.ChestMenuClickEvent$Callback_): void;
        setSwapped(callback: Internal.ChestMenuClickEvent$Callback_): void;
        setDoubleClicked(callback: Internal.ChestMenuClickEvent$Callback_): void;
        clicked(type: Internal.ClickType_, button: number, callback: Internal.ChestMenuClickEvent$Callback_, autoHandle: boolean): void;
        setItem(stack: Internal.ItemStack_): void;
        getItem(): Internal.ItemStack;
        setShiftLeftClicked(callback: Internal.ChestMenuClickEvent$Callback_): void;
        setMiddleClicked(callback: Internal.ChestMenuClickEvent$Callback_): void;
        setShiftRightClicked(callback: Internal.ChestMenuClickEvent$Callback_): void;
        setLeftClicked(callback: Internal.ChestMenuClickEvent$Callback_): void;
        setRightClicked(callback: Internal.ChestMenuClickEvent$Callback_): void;
        set thrown(callback: Internal.ChestMenuClickEvent$Callback_)
        set swapped(callback: Internal.ChestMenuClickEvent$Callback_)
        set doubleClicked(callback: Internal.ChestMenuClickEvent$Callback_)
        set item(stack: Internal.ItemStack_)
        get item(): Internal.ItemStack
        set shiftLeftClicked(callback: Internal.ChestMenuClickEvent$Callback_)
        set middleClicked(callback: Internal.ChestMenuClickEvent$Callback_)
        set shiftRightClicked(callback: Internal.ChestMenuClickEvent$Callback_)
        set leftClicked(callback: Internal.ChestMenuClickEvent$Callback_)
        set rightClicked(callback: Internal.ChestMenuClickEvent$Callback_)
        clicked: number;
        readonly clickHandlers: Internal.List<Internal.ChestMenuClickHandler>;
        readonly index: number;
        readonly x: number;
        readonly y: number;
        inventory: Internal.InventoryKJS;
        readonly gui: Internal.ChestMenuData;
        inventorySlot: number;
        data: Internal.Map<string, any>;
    }
    type ChestMenuSlot_ = ChestMenuSlot;
    abstract class KeyFrameEvent <T extends Internal.GeoAnimatable, E extends Internal.KeyFrameData> {
        constructor(animatable: T, animationTick: number, controller: Internal.AnimationController_<T>, eventKeyFrame: E)
        getAnimationTick(): number;
        getKeyframeData(): E;
        getController(): Internal.AnimationController<T>;
        getAnimatable(): T;
        get animationTick(): number
        get keyframeData(): E
        get controller(): Internal.AnimationController<T>
        get animatable(): T
    }
    type KeyFrameEvent_<T extends Internal.GeoAnimatable, E extends Internal.KeyFrameData> = KeyFrameEvent<T, E>;
    class Font$DisplayMode extends Internal.Enum<Internal.Font$DisplayMode> {
        static valueOf($$0: string): Internal.Font$DisplayMode;
        static values(): Internal.Font$DisplayMode[];
        static readonly SEE_THROUGH: Internal.Font$DisplayMode;
        static readonly NORMAL: Internal.Font$DisplayMode;
        static readonly POLYGON_OFFSET: Internal.Font$DisplayMode;
    }
    type Font$DisplayMode_ = Font$DisplayMode | "normal" | "see_through" | "polygon_offset";
    interface ChannelInboundInvoker {
        abstract fireChannelWritabilityChanged(): this;
        abstract fireExceptionCaught(arg0: Internal.Throwable_): this;
        abstract fireChannelUnregistered(): this;
        abstract fireChannelReadComplete(): this;
        abstract fireChannelRegistered(): this;
        abstract fireChannelRead(arg0: any): this;
        abstract fireChannelActive(): this;
        abstract fireChannelInactive(): this;
        abstract fireUserEventTriggered(arg0: any): this;
    }
    type ChannelInboundInvoker_ = ChannelInboundInvoker;
    class Raids extends Internal.SavedData {
        constructor($$0: Internal.ServerLevel_)
        static load($$0: Internal.ServerLevel_, $$1: Internal.CompoundTag_): Internal.Raids;
        getNearbyRaid($$0: BlockPos_, $$1: number): Internal.Raid;
        static getFileId($$0: Internal.Holder_<Internal.DimensionType>): string;
        get($$0: number): Internal.Raid;
        createOrExtendRaid($$0: Internal.ServerPlayer_): Internal.Raid;
        static canJoinRaid($$0: Internal.Raider_, $$1: Internal.Raid_): boolean;
        tick(): void;
    }
    type Raids_ = Raids;
    class StructureSet extends Internal.Record {
        constructor($$0: Internal.Holder_<Internal.Structure>, $$1: Internal.StructurePlacement_)
        constructor($$0: Internal.List_<Internal.StructureSet$StructureSelectionEntry>, $$1: Internal.StructurePlacement_)
        static entry($$0: Internal.Holder_<Internal.Structure>, $$1: number): Internal.StructureSet$StructureSelectionEntry;
        static entry($$0: Internal.Holder_<Internal.Structure>): Internal.StructureSet$StructureSelectionEntry;
        placement(): Internal.StructurePlacement;
        structures(): Internal.List<Internal.StructureSet$StructureSelectionEntry>;
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.StructureSet>>;
        static readonly DIRECT_CODEC: Internal.Codec<Internal.StructureSet>;
    }
    type StructureSet_ = StructureSet | Special.StructureSet;
    class PrioritizeChunkUpdates extends Internal.Enum<Internal.PrioritizeChunkUpdates> implements Internal.OptionEnum {
        static valueOf($$0: string): Internal.PrioritizeChunkUpdates;
        getKey(): string;
        static byId($$0: number): Internal.PrioritizeChunkUpdates;
        static values(): Internal.PrioritizeChunkUpdates[];
        getCaption(): net.minecraft.network.chat.Component;
        getId(): number;
        get key(): string
        get caption(): net.minecraft.network.chat.Component
        get id(): number
        static readonly NEARBY: Internal.PrioritizeChunkUpdates;
        static readonly NONE: Internal.PrioritizeChunkUpdates;
        static readonly PLAYER_AFFECTED: Internal.PrioritizeChunkUpdates;
    }
    type PrioritizeChunkUpdates_ = "nearby" | PrioritizeChunkUpdates | "player_affected" | "none";
    class PlayerEvents$BreakSpeed extends Internal.PlayerEvents {
        constructor(player: Internal.Player_, state: Internal.BlockState_, original: number, pos: BlockPos_)
        getPos(): BlockPos;
        getEntity(): Internal.Entity;
        getOriginalSpeed(): number;
        getNewSpeed(): number;
        getState(): Internal.BlockState;
        setNewSpeed(newSpeed: number): void;
        get pos(): BlockPos
        get entity(): Internal.Entity
        get originalSpeed(): number
        get newSpeed(): number
        get state(): Internal.BlockState
        set newSpeed(newSpeed: number)
    }
    type PlayerEvents$BreakSpeed_ = PlayerEvents$BreakSpeed;
    interface ChannelHandler {
        /**
         * @deprecated
        */
        abstract exceptionCaught(arg0: Internal.ChannelHandlerContext_, arg1: Internal.Throwable_): void;
        abstract handlerAdded(arg0: Internal.ChannelHandlerContext_): void;
        abstract handlerRemoved(arg0: Internal.ChannelHandlerContext_): void;
    }
    type ChannelHandler_ = ChannelHandler;
    interface EntityDynamicLightSourceBehavior extends Internal.EntityDynamicLightSource {
        abstract getDynamicLightPrevZ(): number;
        abstract setLuminance(arg0: number): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        abstract getLastDynamicLuminance(): number;
        abstract getDynamicLightX(): number;
        abstract getDynamicLightY(): number;
        isDynamicLightEnabled(): boolean;
        abstract getDynamicLightZ(): number;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        abstract getDynamicLightPrevY(): number;
        abstract getDynamicLightPrevX(): number;
        tickEntity(entity: Internal.Entity_): void;
        abstract lambdynlights$setTrackedLitChunkPos(arg0: Internal.LongSet_): void;
        abstract dynamicLightTick(): void;
        abstract lambdynlights$getTrackedLitChunkPos(): Internal.LongSet;
        abstract updateDynamicLightPreviousCoordinates(): void;
        abstract setLastDynamicLuminance(arg0: number): void;
        abstract resetDynamicLight(): void;
        setDynamicLightEnabled(enabled: boolean): void;
        abstract getLuminance(): number;
        get dynamicLightPrevZ(): number
        set luminance(arg0: number)
        get lastDynamicLuminance(): number
        get dynamicLightX(): number
        get dynamicLightY(): number
        get dynamicLightEnabled(): boolean
        get dynamicLightZ(): number
        get dynamicLightPrevY(): number
        get dynamicLightPrevX(): number
        set lastDynamicLuminance(arg0: number)
        set dynamicLightEnabled(enabled: boolean)
        get luminance(): number
    }
    type EntityDynamicLightSourceBehavior_ = EntityDynamicLightSourceBehavior;
    class SpikeFeature extends Internal.Feature<Internal.SpikeConfiguration> {
        constructor($$0: Internal.Codec_<Internal.SpikeConfiguration>)
        static getSpikesForLevel($$0: Internal.WorldGenLevel_): Internal.List<Internal.SpikeFeature$EndSpike>;
        static readonly NUMBER_OF_SPIKES: 10;
    }
    type SpikeFeature_ = SpikeFeature;
    class GrowthAcceleratorBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly POWERED: Internal.BooleanProperty;
    }
    type GrowthAcceleratorBlock_ = GrowthAcceleratorBlock;
    interface SmithingTransformRecipeAccessor {
        abstract getTemplate(): Internal.Ingredient;
        abstract getBase(): Internal.Ingredient;
        abstract getAddition(): Internal.Ingredient;
        get template(): Internal.Ingredient
        get base(): Internal.Ingredient
        get addition(): Internal.Ingredient
    }
    type SmithingTransformRecipeAccessor_ = SmithingTransformRecipeAccessor;
    interface TypeRewriteRule {
        seq(arg0: Internal.List_<Internal.TypeRewriteRule>): this;
        everywhere(arg0: Internal.TypeRewriteRule_, arg1: Internal.PointFreeRule_, arg2: boolean, arg3: boolean): this;
        nop(): this;
        seq(arg0: Internal.TypeRewriteRule_, arg1: Internal.TypeRewriteRule_): this;
        seq(arg0: Internal.TypeRewriteRule_, ...arg1: Internal.TypeRewriteRule_[]): this;
        abstract rewrite<A>(arg0: com.mojang.datafixers.types.Type_<A>): Internal.Optional<Internal.RewriteResult<A, any>>;
        checkOnce(arg0: Internal.TypeRewriteRule_, arg1: Internal.Consumer_<com.mojang.datafixers.types.Type<any>>): this;
        orElse(arg0: Internal.TypeRewriteRule_, arg1: Internal.Supplier_<Internal.TypeRewriteRule>): this;
        all(arg0: Internal.TypeRewriteRule_, arg1: boolean, arg2: boolean): this;
        once(arg0: Internal.TypeRewriteRule_): this;
        orElse(arg0: Internal.TypeRewriteRule_, arg1: Internal.TypeRewriteRule_): this;
        ifSame<B>(arg0: com.mojang.datafixers.types.Type_<B>, arg1: Internal.RewriteResult_<B, any>): this;
        one(arg0: Internal.TypeRewriteRule_): this;
        (arg0: com.mojang.datafixers.types.Type<A>): Internal.Optional_<Internal.RewriteResult<A, any>>;
    }
    type TypeRewriteRule_ = TypeRewriteRule;
    interface ChunkUnloadListeningBlockEntity {
        onChunkUnloaded(): void;
    }
    type ChunkUnloadListeningBlockEntity_ = ChunkUnloadListeningBlockEntity;
    interface InjectedLiquidBlockExtension {
        arch$getFluid(): Internal.FlowingFluid;
    }
    type InjectedLiquidBlockExtension_ = InjectedLiquidBlockExtension;
    class SmallRedMushroomFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type SmallRedMushroomFeature_ = SmallRedMushroomFeature;
    class SplashPotionItem extends Internal.ThrowablePotionItem {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SplashPotionItem_ = SplashPotionItem;
    class FluidBucketItemBuilder extends Internal.ItemBuilder {
        constructor(b: Internal.FluidBuilder_)
        createObject(): Internal.BucketItem;
        readonly fluidBuilder: Internal.FluidBuilder;
    }
    type FluidBucketItemBuilder_ = FluidBucketItemBuilder;
    class SoundEngineExecutor extends Internal.BlockableEventLoop<Internal.Runnable> {
        constructor()
        flush(): void;
        static of<Msg>($$0: string, $$1: Internal.Consumer_<Msg>): Internal.ProcessorHandle<Msg>;
        close(): void;
        ask<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Source>, Internal.Runnable>): Internal.CompletableFuture<Source>;
        askEither<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Internal.Either<Source, Internal.Exception>>, Internal.Runnable>): Internal.CompletableFuture<Source>;
    }
    type SoundEngineExecutor_ = SoundEngineExecutor;
    class ItemOverrides {
        constructor()
        constructor($$0: Internal.ModelBaker_, $$1: Internal.BlockModel_, $$2: Internal.List_<Internal.ItemOverride>)
        resolve($$0: Internal.BakedModel_, $$1: Internal.ItemStack_, $$2: Internal.ClientLevel_, $$3: Internal.LivingEntity_, $$4: number): Internal.BakedModel;
        static readonly EMPTY: Internal.ItemOverrides;
        static readonly NO_OVERRIDE: number;
    }
    type ItemOverrides_ = ItemOverrides;
    class SkySlimeIslandStructure extends Internal.AbstractIslandStructure {
        constructor(structureSettings: Internal.Structure$StructureSettings_)
        type(): Internal.StructureType<Internal.SkySlimeIslandStructure>;
        static readonly CODEC: Internal.Codec<Internal.SkySlimeIslandStructure>;
    }
    type SkySlimeIslandStructure_ = SkySlimeIslandStructure;
    class DepotBlockEntity extends Internal.SmartBlockEntity implements Internal.SidedStorageBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setHeldItem(item: Internal.ItemStack_): void;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getItemStorage(direction: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getHeldItem(): Internal.ItemStack;
        set heldItem(item: Internal.ItemStack_)
        get infiniteBoundingBox(): Internal.AABB
        get heldItem(): Internal.ItemStack
    }
    type DepotBlockEntity_ = DepotBlockEntity;
    interface IActionSource {
        abstract player(): Internal.Optional<Internal.Player>;
        empty(): this;
        ofMachine(machine: Internal.IActionHost_): this;
        abstract context<T>(arg0: T): Internal.Optional<T>;
        ofPlayer(player: Internal.Player_): this;
        ofPlayer(player: Internal.Player_, maybeHost: Internal.IActionHost_): this;
        abstract machine(): Internal.Optional<Internal.IActionHost>;
    }
    type IActionSource_ = IActionSource;
    interface LevelWriter {
        setBlock($$0: BlockPos_, $$1: Internal.BlockState_, $$2: number): boolean;
        abstract destroyBlock(arg0: BlockPos_, arg1: boolean, arg2: Internal.Entity_, arg3: number): boolean;
        abstract setBlock(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: number, arg3: number): boolean;
        addFreshEntity($$0: Internal.Entity_): boolean;
        abstract removeBlock(arg0: BlockPos_, arg1: boolean): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
    }
    type LevelWriter_ = LevelWriter;
    class ResourceKeyArgument$Info <T> implements Internal.ArgumentTypeInfo<Internal.ResourceKeyArgument<T>, Internal.ResourceKeyArgument$Info$Template<>> {
        constructor()
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        deserializeFromNetwork($$0: Internal.FriendlyByteBuf_): Internal.ResourceKeyArgument$Info$Template<>;
        unpack($$0: Internal.ResourceKeyArgument_<T>): Internal.ResourceKeyArgument$Info$Template<>;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        serializeToJson($$0: Internal.ResourceKeyArgument$Info$Template_<>, $$1: Internal.JsonObject_): void;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
        serializeToNetwork($$0: Internal.ResourceKeyArgument$Info$Template_<>, $$1: Internal.FriendlyByteBuf_): void;
    }
    type ResourceKeyArgument$Info_<T> = ResourceKeyArgument$Info<T>;
    interface EnergyStorage {
        abstract insert(arg0: number, arg1: Internal.TransactionContext_): number;
        supportsExtraction(): boolean;
        abstract getAmount(): number;
        supportsInsertion(): boolean;
        abstract extract(arg0: number, arg1: Internal.TransactionContext_): number;
        abstract getCapacity(): number;
        get amount(): number
        get capacity(): number
        readonly EMPTY: Internal.EnergyStorage;
        readonly ITEM: Internal.ItemApiLookup<Internal.EnergyStorage, Internal.ContainerItemContext>;
        readonly SIDED: Internal.BlockApiLookup<Internal.EnergyStorage, Internal.Direction>;
    }
    type EnergyStorage_ = EnergyStorage;
    interface RiderShieldingMount {
        abstract getRiderShieldingHeight(): number;
        get riderShieldingHeight(): number
        (): number;
    }
    type RiderShieldingMount_ = RiderShieldingMount;
    interface Thread$Builder$OfVirtual extends Internal.Thread$Builder {
        abstract inheritInheritableThreadLocals(arg0: boolean): this;
        abstract start(arg0: Internal.Runnable_): Internal.Thread;
        name(arg0: string, arg1: number): Internal.Thread$Builder;
        abstract factory(): Internal.ThreadFactory;
        name(arg0: string): Internal.Thread$Builder;
        uncaughtExceptionHandler(arg0: Internal.Thread$UncaughtExceptionHandler_): Internal.Thread$Builder;
        abstract unstarted(arg0: Internal.Runnable_): Internal.Thread;
    }
    type Thread$Builder$OfVirtual_ = Thread$Builder$OfVirtual;
    interface Channel extends Internal.Closeable {
        abstract isOpen(): boolean;
        abstract close(): void;
        get open(): boolean
    }
    type Channel_ = Channel;
    class Context {
        static reportError(cx: Internal.Context_, message: string, lineno: number, lineSource: string, lineOffset: number, sourceName: string): void;
        getTypeWrappers(): Internal.TypeWrappers;
        setMaximumInterpreterStackDepth(max: number): void;
        setProperty(key: string, value: any): void;
        static javaToJS(cx: Internal.Context_, value: any, scope: Internal.Scriptable_): any;
        static reportRuntimeError(cx: Internal.Context_, message: string, sourceName: string, lineno: number, lineSource: string, lineOffset: number): Internal.EvaluatorException;
        initSafeStandardObjects(scope: Internal.ScriptableObject_): Internal.Scriptable;
        setApplicationClassLoader(loader: Internal.ClassLoader_): void;
        putThreadLocal(key: any, value: any): void;
        setGenerateObserverCount(generateObserverCount: boolean): void;
        static enter(): Internal.Context;
        static reportRuntimeError1(messageId: string, arg1: any, cx: Internal.Context_): Internal.EvaluatorException;
        getClassShutter(): Internal.ClassShutter;
        toString(value: any): string;
        createClassLoader(parent: Internal.ClassLoader_): Internal.GeneratedClassLoader;
        evaluateReader(scope: Internal.Scriptable_, in_: Internal.Reader_, sourceName: string, lineno: number, securityDomain: any): any;
        newObject(scope: Internal.Scriptable_): Internal.Scriptable;
        toNumber(value: any): number;
        static getSourcePositionFromStack(cx: Internal.Context_, linep: number[]): string;
        newObject(scope: Internal.Scriptable_, constructorName: string, args: any[]): Internal.Scriptable;
        getInstructionObserverThreshold(): number;
        getProperty(key: string): any;
        toBoolean(value: any): boolean;
        getThreadLocal(key: any): any;
        wrapCustomJavaToJs(javaObject: any): Internal.CustomJavaToJsWrapper;
        hasTypeWrappers(): boolean;
        getRegExp(): Internal.RegExp;
        storeScriptable(value: Internal.Scriptable_): void;
        newArray(scope: Internal.Scriptable_, elements: any[]): Internal.Scriptable;
        getErrorReporter(): Internal.ErrorReporter;
        initSafeStandardObjects(): Internal.ScriptableObject;
        addCustomJavaToJsWrapper<T>(predicate: Internal.Predicate_<T>, provider: Internal.CustomJavaToJsWrapperProvider_<T>): void;
        static reportRuntimeError4(messageId: string, arg1: any, arg2: any, arg3: any, arg4: any, cx: Internal.Context_): Internal.EvaluatorException;
        getImplementationVersion(): string;
        static throwAsScriptRuntimeEx(e: Internal.Throwable_, cx: Internal.Context_): Internal.RuntimeException;
        setWrapFactory(wrapFactory: Internal.WrapFactory_): void;
        getRemapper(): Internal.Remapper;
        initStandardObjects(scope: Internal.ScriptableObject_, sealed: boolean): Internal.ScriptableObject;
        initStandardObjects(): Internal.ScriptableObject;
        lastStoredScriptable(): Internal.Scriptable;
        initStandardObjects(scope: Internal.ScriptableObject_): Internal.Scriptable;
        setRemapper(remapper: Internal.Remapper_): void;
        compileString(source: string, sourceName: string, lineno: number, securityDomain: any): Internal.Script;
        doTopCall(scope: Internal.Scriptable_, callable: dev.latvian.mods.rhino.Callable_, thisObj: Internal.Scriptable_, args: any[], isTopLevelStrict: boolean): any;
        callSync(callable: dev.latvian.mods.rhino.Callable_, scope: Internal.Scriptable_, thisObj: Internal.Scriptable_, args: any[]): any;
        newClassSerialNumber(): number;
        static reportRuntimeError(message: string, cx: Internal.Context_): Internal.EvaluatorException;
        initSafeStandardObjects(scope: Internal.ScriptableObject_, sealed: boolean): Internal.ScriptableObject;
        static reportError(cx: Internal.Context_, message: string): void;
        static reportWarning(cx: Internal.Context_, message: string, sourceName: string, lineno: number, lineSource: string, lineOffset: number): void;
        addToScope(scope: Internal.Scriptable_, name: string, value: any): void;
        static reportRuntimeError2(messageId: string, arg1: any, arg2: any, cx: Internal.Context_): Internal.EvaluatorException;
        static reportRuntimeError0(messageId: string, cx: Internal.Context_): Internal.EvaluatorException;
        getMaximumInterpreterStackDepth(): number;
        static getUndefinedValue(): any;
        newObject(scope: Internal.Scriptable_, constructorName: string): Internal.Scriptable;
        setTopCall(scope: Internal.Scriptable_): void;
        evaluateString(scope: Internal.Scriptable_, source: string, sourceName: string, lineno: number, securityDomain: any): any;
        getProperty<T>(key: string, def: T): T;
        setInstructionObserverThreshold(threshold: number): void;
        getTopCallOrThrow(): Internal.Scriptable;
        static reportRuntimeError3(messageId: string, arg1: any, arg2: any, arg3: any, cx: Internal.Context_): Internal.EvaluatorException;
        removeThreadLocal(key: any): void;
        isStrictMode(): boolean;
        static jsToJava(cx: Internal.Context_, value: any, desiredType: typeof any): any;
        getWrapFactory(): Internal.WrapFactory;
        toObject(value: any, scope: Internal.Scriptable_): Internal.Scriptable;
        compileReader(in_: Internal.Reader_, sourceName: string, lineno: number, securityDomain: any): Internal.Script;
        setClassShutter(shutter: Internal.ClassShutter_): void;
        static reportWarning(message: string, cx: Internal.Context_): void;
        hasTopCallScope(): boolean;
        getTopCallScope(): Internal.Scriptable;
        newArray(scope: Internal.Scriptable_, length: number): Internal.Scriptable;
        addCustomJavaToJsWrapper<T>(type: T, provider: Internal.CustomJavaToJsWrapperProvider_<T>): void;
        getApplicationClassLoader(): Internal.ClassLoader;
        get typeWrappers(): Internal.TypeWrappers
        set maximumInterpreterStackDepth(max: number)
        set applicationClassLoader(loader: Internal.ClassLoader_)
        set generateObserverCount(generateObserverCount: boolean)
        get classShutter(): Internal.ClassShutter
        get instructionObserverThreshold(): number
        get regExp(): Internal.RegExp
        get errorReporter(): Internal.ErrorReporter
        get implementationVersion(): string
        set wrapFactory(wrapFactory: Internal.WrapFactory_)
        get remapper(): Internal.Remapper
        set remapper(remapper: Internal.Remapper_)
        get maximumInterpreterStackDepth(): number
        get undefinedValue(): any
        set topCall(scope: Internal.Scriptable_)
        set instructionObserverThreshold(threshold: number)
        get topCallOrThrow(): Internal.Scriptable
        get strictMode(): boolean
        get wrapFactory(): Internal.WrapFactory
        set classShutter(shutter: Internal.ClassShutter_)
        get topCallScope(): Internal.Scriptable
        get applicationClassLoader(): Internal.ClassLoader
        readonly lock: any;
        generateObserverCount: boolean;
    }
    type Context_ = Context;
    class WaterWheelBlock extends Internal.DirectionalKineticBlock implements Internal.IBE<Internal.WaterWheelBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.WaterWheelBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.WaterWheelBlockEntity>;
        getBlockEntityClass(): typeof Internal.WaterWheelBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.WaterWheelBlockEntity>;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.WaterWheelBlockEntity;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.WaterWheelBlockEntity>): void;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.WaterWheelBlockEntity
        get blockEntityType(): Internal.BlockEntityType<Internal.WaterWheelBlockEntity>
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
    }
    type WaterWheelBlock_ = WaterWheelBlock;
    interface IFacadeItem {
        abstract getTextureItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        abstract getTextureBlockState(arg0: Internal.ItemStack_): Internal.BlockState;
        abstract createPartFromItemStack(arg0: Internal.ItemStack_, arg1: Internal.Direction_): Internal.IFacadePart;
    }
    type IFacadeItem_ = IFacadeItem;
    class BezierTrackPointLocation extends Internal.Record {
        constructor(curveTarget: BlockPos_, segment: number)
        curveTarget(): BlockPos;
        segment(): number;
    }
    type BezierTrackPointLocation_ = BezierTrackPointLocation;
    class MapColor$Brightness extends Internal.Enum<Internal.MapColor$Brightness> {
        static byId($$0: number): Internal.MapColor$Brightness;
        static values(): Internal.MapColor$Brightness[];
        static valueOf($$0: string): Internal.MapColor$Brightness;
        static readonly LOW: Internal.MapColor$Brightness;
        static readonly LOWEST: Internal.MapColor$Brightness;
        readonly id: number;
        readonly modifier: number;
        static readonly NORMAL: Internal.MapColor$Brightness;
        static readonly HIGH: Internal.MapColor$Brightness;
    }
    type MapColor$Brightness_ = "normal" | "high" | "low" | "lowest" | MapColor$Brightness;
    class MatchingPipeBlock extends Internal.ContainerAdjacentNetworkedPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type MatchingPipeBlock_ = MatchingPipeBlock;
    class PoiType extends Internal.Record implements Internal.PoiTypeAccessor {
        constructor($$0: Internal.Set_<Internal.BlockState>, $$1: number, $$2: number)
        maxTickets(): number;
        setMatchingStates(arg0: Internal.Set_<any>): void;
        is($$0: Internal.BlockState_): boolean;
        matchingStates(): Internal.Set<Internal.BlockState>;
        validRange(): number;
        set matchingStates(arg0: Internal.Set_<any>)
        static readonly NONE: Internal.Predicate<Internal.Holder<Internal.PoiType>>;
    }
    type PoiType_ = Special.PointOfInterestType | PoiType;
    class ModifiableSwordItem extends Internal.ModifiableItem {
        constructor(properties: Internal.Item$Properties_, toolDefinition: Internal.ToolDefinition_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getDisplayStack(item: Internal.Item_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLocalizedName(): net.minecraft.network.chat.Component;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: Internal.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        /**
         * @deprecated
        */
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: slimeknights.tconstruct.library.utils.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        setAttackDamage(attackDamage: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get localizedName(): net.minecraft.network.chat.Component
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ModifiableSwordItem_ = ModifiableSwordItem;
    class WideGaugeComicallyLargeBogeyBlock extends Internal.WideGaugeBogeyBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type WideGaugeComicallyLargeBogeyBlock_ = WideGaugeComicallyLargeBogeyBlock;
    class InfinityUpgradeItem extends Internal.UpgradeItemBase<Internal.InfinityUpgradeItem$Wrapper> {
        constructor(upgradeTypeLimitConfig: any_, admin: boolean)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        createInventoryPartHandler(parent: Internal.InventoryHandler_, slotRange: Internal.SlotRange_): Internal.IInventoryPartHandler;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        getPermissionLevel(): number;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getType(): Internal.UpgradeType<Internal.InfinityUpgradeItem$Wrapper>;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        get permissionLevel(): number
        set armorToughness(armorToughness: number)
        get type(): Internal.UpgradeType<Internal.InfinityUpgradeItem$Wrapper>
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly UPGRADE_CONFLICT_DEFINITIONS: [Internal.IUpgradeItem$UpgradeConflictDefinition];
        static readonly TYPE: Internal.UpgradeType<Internal.InfinityUpgradeItem$Wrapper>;
    }
    type InfinityUpgradeItem_ = InfinityUpgradeItem;
    class TankUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.TankUpgradeWrapper, Internal.TankUpgradeItem> implements Internal.SingleSlotStorage<Internal.FluidVariant>, Internal.IRenderedTankUpgrade, Internal.IStackableContentsUpgrade, Internal.ITickableUpgrade {
        fill(resource: Internal.FluidVariant_, maxFill: number, ctx: Internal.TransactionContext_, ignoreInOutLimit: boolean): number;
        getResource(): any;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        supportsInsertion(): boolean;
        tick(entity: Internal.Entity_, world: Internal.Level_, pos: BlockPos_): void;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.FluidVariant>>;
        supportsExtraction(): boolean;
        extract(arg0: any, arg1: number, arg2: Internal.TransactionContext_): number;
        getSlot(slot: number): Internal.SingleSlotStorage<Internal.FluidVariant>;
        getAmount(): number;
        isResourceBlank(): boolean;
        setTankRenderInfoUpdateCallback(updateTankRenderInfoCallback: Internal.Consumer_<Internal.IRenderedTankUpgrade$TankRenderInfo>): void;
        getSlotCount(): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        fillHandler(storage: Internal.Storage_<Internal.FluidVariant>): boolean;
        getSlots(): Internal.List<Internal.SingleSlotStorage<Internal.FluidVariant>>;
        getContents(): Internal.FluidStack;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        forceUpdateTankRenderInfo(): void;
        getMinimumMultiplierRequired(): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        getTankCapacity(): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.FluidVariant_): Internal.StorageView<Internal.FluidVariant>;
        getInventory(): Internal.SlottedStackStorage;
        static asClass<T>(): Internal.Storage<T>;
        drain(maxDrain: number, ctx: Internal.TransactionContext_, ignoreInOutLimit: boolean): number;
        getUnderlyingView(): Internal.StorageView<Internal.FluidVariant>;
        drainHandler(storage: Internal.Storage_<Internal.FluidVariant>): boolean;
        static getContents(upgrade: Internal.ItemStack_): Internal.FluidStack;
        insert(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.FluidVariant>>;
        insert(arg0: any, arg1: number, arg2: Internal.TransactionContext_): number;
        hideSettingsTab(): boolean;
        extract(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        onAdded(): void;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.FluidVariant>>;
        getCapacity(): number;
        onBeforeRemoved(): void;
        get resource(): any
        get amount(): number
        get resourceBlank(): boolean
        set tankRenderInfoUpdateCallback(updateTankRenderInfoCallback: Internal.Consumer_<Internal.IRenderedTankUpgrade$TankRenderInfo>)
        get slotCount(): number
        get slots(): Internal.List<Internal.SingleSlotStorage<Internal.FluidVariant>>
        get contents(): Internal.FluidStack
        get minimumMultiplierRequired(): number
        get tankCapacity(): number
        get inventory(): Internal.SlottedStackStorage
        get underlyingView(): Internal.StorageView<Internal.FluidVariant>
        get version(): number
        get capacity(): number
        static readonly INPUT_SLOT: 0;
        static readonly OUTPUT_SLOT: 1;
    }
    type TankUpgradeWrapper_ = TankUpgradeWrapper;
    /**
     * @deprecated
    */
    class SolidPredicate extends Internal.StateTestingPredicate {
        constructor($$0: Vec3i_)
        static hasSturdyFace($$0: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        and(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Vec3i_, $$1: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        negate(): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static solid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static insideWorld($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        or(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static solid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static alwaysTrue(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Vec3i_, ...$$1: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Vec3i_, $$1: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static wouldSurvive($$0: Internal.BlockState_, $$1: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, $$1: Internal.List_<Internal.Fluid>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static not($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, ...$$1: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static hasSturdyFace($$0: Vec3i_, $$1: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks(...$$0: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids(...$$0: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static readonly CODEC: Internal.Codec<Internal.SolidPredicate>;
    }
    type SolidPredicate_ = SolidPredicate;
    class SmithingTableBlock extends Internal.CraftingTableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type SmithingTableBlock_ = SmithingTableBlock;
    class LazyOptional <T> {
        addListener(listener: Internal.NonNullConsumer_<Internal.LazyOptional<T>>): void;
        getValueUnsafer(): T;
        ifPresent(consumer: Internal.NonNullConsumer_<T>): void;
        cast<X>(): Internal.LazyOptional<X>;
        invalidate(): void;
        static empty<T>(): Internal.LazyOptional<T>;
        lazyMap<U>(mapper: Internal.NonNullFunction_<T, U>): Internal.LazyOptional<U>;
        static fromOptional<T>(regularOptional: Internal.Optional_<T>): Internal.LazyOptional<T>;
        static ofObject<T>(o: T): Internal.LazyOptional<T>;
        map<U>(mapper: Internal.NonNullFunction_<T, U>): Internal.Optional<U>;
        filter(predicate: Internal.Predicate_<T>): Internal.Optional<T>;
        static of<T>(instanceSupplier: io.github.fabricators_of_create.porting_lib.common.util.NonNullSupplier_<T>): Internal.LazyOptional<T>;
        resolve(): Internal.Optional<T>;
        orElse(other: T): T;
        isPresent(): boolean;
        orElseThrow<X extends Internal.Throwable>(exceptionSupplier: io.github.fabricators_of_create.porting_lib.common.util.NonNullSupplier_<X>): T;
        orElseGet(other: io.github.fabricators_of_create.porting_lib.common.util.NonNullSupplier_<T>): T;
        flatMap<U>(mapper: Internal.NonNullFunction_<T, Internal.Optional<U>>): Internal.Optional<U>;
        get valueUnsafer(): T
        get present(): boolean
        supplier: io.github.fabricators_of_create.porting_lib.common.util.NonNullSupplier<T>;
        static readonly EMPTY: Internal.LazyOptional<void>;
    }
    type LazyOptional_<T> = LazyOptional<T>;
    class ItemVaultMountedStorageType extends Internal.MountedItemStorageType<Internal.ItemVaultMountedStorage> {
        constructor()
        mount(level: Internal.Level_, state: Internal.BlockState_, pos: BlockPos_, be: Internal.BlockEntity_): Internal.ItemVaultMountedStorage;
    }
    type ItemVaultMountedStorageType_ = ItemVaultMountedStorageType;
    class EncasedFanBlock extends Internal.DirectionalKineticBlock implements Internal.IBE<Internal.EncasedFanBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getBlockEntityType(): Internal.BlockEntityType<Internal.EncasedFanBlockEntity>;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityClass(): typeof Internal.EncasedFanBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.EncasedFanBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.EncasedFanBlockEntity>): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.EncasedFanBlockEntity>;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.EncasedFanBlockEntity;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityType(): Internal.BlockEntityType<Internal.EncasedFanBlockEntity>
        get blockEntityClass(): typeof Internal.EncasedFanBlockEntity
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
    }
    type EncasedFanBlock_ = EncasedFanBlock;
    class OverlayTexture implements Internal.AutoCloseable {
        constructor()
        static pack($$0: number, $$1: number): number;
        static pack($$0: number, $$1: boolean): number;
        close(): void;
        teardownOverlayColor(): void;
        static v($$0: boolean): number;
        static u($$0: number): number;
        setupOverlayColor(): void;
        static readonly NO_OVERLAY: 655360;
        static readonly WHITE_OVERLAY_V: 10;
        static readonly NO_WHITE_U: 0;
        static readonly RED_OVERLAY_V: 3;
    }
    type OverlayTexture_ = OverlayTexture;
    class FunctionFactory extends Internal.Record {
        constructor(name: string, minArgs: number, maxArgs: number, supplier: Internal.FunctionFactory$FuncSupplier_)
        name(): string;
        static of0(name: string, supplier: Internal.Supplier_<Internal.Unit>): Internal.FunctionFactory;
        create(args: Internal.Unit_[]): Internal.Unit;
        static of(name: string, args: number, supplier: Internal.FunctionFactory$FuncSupplier_): Internal.FunctionFactory;
        maxArgs(): number;
        static of(name: string, minArgs: number, maxArgs: number, supplier: Internal.FunctionFactory$FuncSupplier_): Internal.FunctionFactory;
        supplier(): Internal.FunctionFactory$FuncSupplier;
        minArgs(): number;
        static of1(name: string, supplier: Internal.FunctionFactory$Arg1_): Internal.FunctionFactory;
        static of2(name: string, supplier: Internal.FunctionFactory$Arg2_): Internal.FunctionFactory;
        static of3(name: string, supplier: Internal.FunctionFactory$Arg3_): Internal.FunctionFactory;
    }
    type FunctionFactory_ = FunctionFactory;
    interface NBTSerializable {
        abstract toNBT(): Internal.Tag;
        (): Internal.Tag_;
    }
    type NBTSerializable_ = NBTSerializable;
    class TextAttribute extends Internal.AttributedCharacterIterator$Attribute {
        static readonly FAMILY: Internal.TextAttribute;
        static readonly TRACKING_LOOSE: 0.04;
        static readonly UNDERLINE_LOW_DOTTED: 3;
        static readonly SWAP_COLORS_ON: true;
        static readonly JUSTIFICATION: Internal.TextAttribute;
        static readonly WEIGHT_MEDIUM: 1.5;
        static readonly RUN_DIRECTION_RTL: true;
        static readonly WEIGHT: Internal.TextAttribute;
        static readonly RUN_DIRECTION_LTR: false;
        static readonly JUSTIFICATION_NONE: 0.0;
        static readonly INPUT_METHOD_HIGHLIGHT: Internal.TextAttribute;
        static readonly WEIGHT_DEMILIGHT: 0.875;
        static readonly WIDTH: Internal.TextAttribute;
        static readonly TRANSFORM: Internal.TextAttribute;
        static readonly UNDERLINE: Internal.TextAttribute;
        static readonly JUSTIFICATION_FULL: 1.0;
        static readonly WEIGHT_REGULAR: 1.0;
        static readonly WEIGHT_HEAVY: 2.25;
        static readonly INPUT_METHOD_UNDERLINE: Internal.TextAttribute;
        static readonly UNDERLINE_ON: 0;
        static readonly FOREGROUND: Internal.TextAttribute;
        static readonly LIGATURES: Internal.TextAttribute;
        static readonly WEIGHT_ULTRABOLD: 2.75;
        static readonly BACKGROUND: Internal.TextAttribute;
        static readonly WEIGHT_DEMIBOLD: 1.75;
        static readonly TRACKING_TIGHT: -0.04;
        static readonly SIZE: Internal.TextAttribute;
        static readonly WEIGHT_LIGHT: 0.75;
        static readonly STRIKETHROUGH_ON: true;
        static readonly TRACKING: Internal.TextAttribute;
        static readonly CHAR_REPLACEMENT: Internal.TextAttribute;
        static readonly UNDERLINE_LOW_ONE_PIXEL: 1;
        static readonly UNDERLINE_LOW_TWO_PIXEL: 2;
        static readonly BIDI_EMBEDDING: Internal.TextAttribute;
        static readonly UNDERLINE_LOW_GRAY: 4;
        static readonly WEIGHT_BOLD: 2.0;
        static readonly UNDERLINE_LOW_DASHED: 5;
        static readonly SWAP_COLORS: Internal.TextAttribute;
        static readonly LIGATURES_ON: 1;
        static readonly WIDTH_SEMI_EXTENDED: 1.25;
        static readonly WIDTH_CONDENSED: 0.75;
        static readonly WIDTH_SEMI_CONDENSED: 0.875;
        static readonly STRIKETHROUGH: Internal.TextAttribute;
        static readonly NUMERIC_SHAPING: Internal.TextAttribute;
        static readonly WIDTH_REGULAR: 1.0;
        static readonly POSTURE: Internal.TextAttribute;
        static readonly SUPERSCRIPT_SUB: -1;
        static readonly WEIGHT_SEMIBOLD: 1.25;
        static readonly RUN_DIRECTION: Internal.TextAttribute;
        static readonly WIDTH_EXTENDED: 1.5;
        static readonly KERNING_ON: 1;
        static readonly WEIGHT_EXTRABOLD: 2.5;
        static readonly KERNING: Internal.TextAttribute;
        static readonly WEIGHT_EXTRA_LIGHT: 0.5;
        static readonly SUPERSCRIPT: Internal.TextAttribute;
        static readonly POSTURE_REGULAR: 0.0;
        static readonly FONT: Internal.TextAttribute;
        static readonly POSTURE_OBLIQUE: 0.2;
        static readonly SUPERSCRIPT_SUPER: 1;
    }
    type TextAttribute_ = TextAttribute;
    interface Matrix3dc {
        abstract mapnYnZX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract scale(arg0: number, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapXZnY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotateLocalZ(arg0: number, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotate(arg0: Internal.Quaterniondc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnZXY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnYXnZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mapnYnZnX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract m01(): number;
        abstract mapnZnXY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapZnYnX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract m20(): number;
        abstract mul(arg0: Internal.Matrix3fc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract negateY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
        abstract quadraticFormProduct(arg0: Internal.Vector3dc_): number;
        abstract lerp(arg0: Internal.Matrix3dc_, arg1: number, arg2: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapZXnY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapXnYnZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract scaleLocal(arg0: number, arg1: number, arg2: number, arg3: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract get(arg0: number[]): number[];
        abstract mapYZnX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        abstract scale(arg0: number, arg1: number, arg2: number, arg3: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnZnYnX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract m12(): number;
        abstract mapnZXnY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract transform(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract positiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract get(arg0: number[], arg1: number): number[];
        abstract mapnXZY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract normal(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotateLocal(arg0: Internal.Quaterniondc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract equals(arg0: Internal.Matrix3dc_, arg1: number): boolean;
        abstract getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
        abstract transformTranspose(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract rotate(arg0: Internal.Quaternionfc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapYXnZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract rotateX(arg0: number, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract scale(arg0: Internal.Vector3dc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mul(arg0: Internal.Matrix3dc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract m00(): number;
        abstract transpose(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapYnXnZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mulComponentWise(arg0: Internal.Matrix3dc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract negateZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract get(arg0: number[]): number[];
        abstract determinant(): number;
        abstract rotate(arg0: Internal.AxisAngle4d_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapZXY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract invert(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract transformTranspose(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract mapnYnXnZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract normalizedPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract getTransposedFloats(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mulLocal(arg0: Internal.Matrix3dc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getEulerAnglesZYX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract getColumn(arg0: number, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract obliqueZ(arg0: number, arg1: number, arg2: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getFloats(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getTransposed(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract transform(arg0: Vec3f_): Vec3f;
        abstract lookAlong(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract m11(): number;
        abstract positiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract mapnXnZY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotateLocal(arg0: Internal.Quaternionfc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapYnXZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getRowColumn(arg0: number, arg1: number): number;
        abstract transformTranspose(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateLocalX(arg0: number, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotate(arg0: number, arg1: Internal.Vector3dc_, arg2: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract quadraticFormProduct(arg0: Internal.Vector3fc_): number;
        abstract isFinite(): boolean;
        abstract m22(): number;
        abstract getTransposedFloats(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract sub(arg0: Internal.Matrix3dc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapYXZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotateY(arg0: number, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapXnZnY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotateZYX(arg0: number, arg1: number, arg2: number, arg3: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract reflect(arg0: number, arg1: number, arg2: number, arg3: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract get(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract rotateTowards(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnZYX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract normalizedPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract mapZnXnY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapYZX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnYZnX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract cofactor(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getRow(arg0: number, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract getScale(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract mapXnZY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnXnZnY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract m10(): number;
        abstract get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract mapZnXY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnYXZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract reflect(arg0: Internal.Quaterniondc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract add(arg0: Internal.Matrix3dc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract reflect(arg0: Internal.Vector3dc_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getTransposed(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract mapnXZnY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapYnZX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract getEulerAnglesXYZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract get(arg0: number[], arg1: number): number[];
        abstract rotateLocalY(arg0: number, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnYnXZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract m02(): number;
        abstract m21(): number;
        abstract mapZnYX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract negateX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateZ(arg0: number, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
        abstract mapnXnYZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        abstract getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract mapnZYnX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapZYnX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getFloats(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract normalizedPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract get(arg0: number, arg1: number): number;
        abstract getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract rotate(arg0: Internal.AxisAngle4f_, arg1: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
        abstract mapnXYnZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract positiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnYZX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract getToAddress(arg0: number): this;
        abstract mapXZY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapYnZnX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnXnYnZ(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnZnYX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapZYX(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnZnXnY(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        get finite(): boolean
    }
    type Matrix3dc_ = Matrix3dc;
    class TankWidget extends Internal.SlotWidget {
        constructor(stack: Internal.EmiIngredient_, x: number, y: number, width: number, height: number, capacity: number)
    }
    type TankWidget_ = TankWidget;
    class AlternatorBlockEntity extends Internal.KineticBlockEntity implements Internal.EnergyTransferable {
        constructor(typeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getCachedEnergy(side: Internal.Direction_): Internal.EnergyStorage;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getEnergyStorage(side: Internal.Direction_): Internal.EnergyStorage;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        read(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        onLoad(): void;
        isEnergyOutput(side: Internal.Direction_): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        static getEnergyProductionRate(rpm: number): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        firstTick(): void;
        updateCache(): void;
        isEnergyInput(side: Internal.Direction_): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        setCache(side: Internal.Direction_, storage: io.github.fabricators_of_create.porting_lib.util.LazyOptional_<Internal.EnergyStorage>): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
    }
    type AlternatorBlockEntity_ = AlternatorBlockEntity;
    interface IMutableAlloyTank extends Internal.IAlloyTank {
        stopOpen($$0: Internal.Player_): void;
        tryClear($$0: any): void;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        /**
         * @deprecated
        */
        removeItem(index: number, count: number): Internal.ItemStack;
        getSlots(): number;
        /**
         * @deprecated
        */
        setChanged(): void;
        /**
         * @deprecated
        */
        getContainerSize(): number;
        abstract getFluidInTank(arg0: number): Internal.FluidStack;
        /**
         * @deprecated
        */
        setItem(index: number, stack: Internal.ItemStack_): void;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        removeItemNoUpdate(index: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        abstract getTanks(): number;
        /**
         * @deprecated
        */
        getItem(index: number): Internal.ItemStack;
        abstract getTemperature(): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        abstract fill(arg0: Internal.FluidStack_): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        /**
         * @deprecated
        */
        isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        abstract drain(arg0: number, arg1: Internal.FluidStack_): Internal.FluidStack;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        stillValid(player: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        /**
         * @deprecated
        */
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        abstract canFit(arg0: Internal.FluidStack_, arg1: number): boolean;
        get slots(): number
        /**
         * @deprecated
        */
        get containerSize(): number
        get width(): number
        get maxStackSize(): number
        get tanks(): number
        get temperature(): number
        set transferCooldown(currentTime: number)
        /**
         * @deprecated
        */
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
    }
    type IMutableAlloyTank_ = IMutableAlloyTank;
    class WebBlock extends Internal.Block implements Internal.IShearable {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type WebBlock_ = WebBlock;
    abstract class AbstractPiglin extends Internal.Monster {
        constructor($$0: Internal.EntityType_<Internal.AbstractPiglin>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        isConverting(): boolean;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        abstract getArmPose(): Internal.PiglinArmPose;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        isAdult(): boolean;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setImmuneToZombification($$0: boolean): void;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get converting(): boolean
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get armPose(): Internal.PiglinArmPose
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get adult(): boolean
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set immuneToZombification($$0: boolean)
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type AbstractPiglin_ = AbstractPiglin;
    class BuddingAmethystBlock extends Internal.AmethystBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        static canClusterGrowAtState($$0: Internal.BlockState_): boolean;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly GROWTH_CHANCE: 5;
    }
    type BuddingAmethystBlock_ = BuddingAmethystBlock;
    class SpawnWanderingCyclops extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(configFactoryIn: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type SpawnWanderingCyclops_ = SpawnWanderingCyclops;
    abstract class Buffer {
        capacity(): number;
        reset(): this;
        remaining(): number;
        abstract isDirect(): boolean;
        limit(): number;
        position(): number;
        rewind(): this;
        abstract array(): any;
        abstract arrayOffset(): number;
        mark(): this;
        limit(arg0: number): this;
        clear(): this;
        flip(): this;
        position(arg0: number): this;
        abstract slice(): this;
        hasRemaining(): boolean;
        abstract isReadOnly(): boolean;
        abstract slice(arg0: number, arg1: number): this;
        abstract hasArray(): boolean;
        abstract duplicate(): this;
        get direct(): boolean
        get readOnly(): boolean
    }
    type Buffer_ = Buffer;
    interface LerpedFloat$Chaser {
        abstract chase(arg0: number, arg1: number, arg2: number): number;
        exp(maxEffectiveSpeed: number): this;
        (arg0: number, arg1: number, arg2: number): number;
        readonly LINEAR: Internal.LerpedFloat$Chaser;
        readonly EXP: Internal.LerpedFloat$Chaser;
        readonly IDLE: Internal.LerpedFloat$Chaser;
    }
    type LerpedFloat$Chaser_ = LerpedFloat$Chaser;
    abstract class ControllerBlock extends Internal.InventoryBlock implements Internal.LandPathNodeTypesRegistry$StaticPathNodeTypeProvider {
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPathNodeType(state: Internal.BlockState_, neighbor: boolean): Internal.BlockPathTypes;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly ACTIVE: Internal.BooleanProperty;
        static readonly IN_STRUCTURE: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type ControllerBlock_ = ControllerBlock;
    class CoralPlantBlock extends Internal.BaseCoralPlantTypeBlock {
        constructor($$0: Internal.Block_, $$1: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type CoralPlantBlock_ = CoralPlantBlock;
    interface ETFEntityRenderState$ETFRenderStateInit {
        abstract make(arg0: Internal.ETFEntity_): Internal.ETFEntityRenderState;
        (arg0: Internal.ETFEntity): Internal.ETFEntityRenderState_;
    }
    type ETFEntityRenderState$ETFRenderStateInit_ = ETFEntityRenderState$ETFRenderStateInit;
    interface ReferenceSet <K> extends Internal.Set<K>, Internal.ReferenceCollection<K> {
        abstract addAll(arg0: Internal.Collection_<K>): boolean;
        of<K>(...arg0: K[]): this;
        of<K>(arg0: K): this;
        abstract isEmpty(): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        parallelStream(): Internal.Stream<K>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        of<K>(): this;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        abstract contains(arg0: any): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        iterator(): Internal.Iterator<any>;
        abstract toArray<T>(arg0: T[]): T[];
        forEach(arg0: Internal.Consumer_<K>): void;
        abstract remove(arg0: any): boolean;
        abstract toArray(): any[];
        removeIf(arg0: Internal.Predicate_<K>): boolean;
        abstract size(): number;
        abstract hashCode(): number;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        of<K>(arg0: K, arg1: K, arg2: K): this;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        abstract clear(): void;
        of<K>(arg0: K, arg1: K): this;
        abstract equals(arg0: any): boolean;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        abstract add(arg0: K): boolean;
        stream(): Internal.Stream<K>;
        get empty(): boolean
    }
    type ReferenceSet_<K> = ReferenceSet<K>;
    class VoxelShapeSimpleCube extends Internal.VoxelShape implements Internal.VoxelShapeCaster {
        constructor(voxels: Internal.DiscreteVoxelShape_, minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number)
        intersects(box: Internal.AABB_, blockX: number, blockY: number, blockZ: number): boolean;
        readonly isTiny: boolean;
    }
    type VoxelShapeSimpleCube_ = VoxelShapeSimpleCube;
    /**
     * @deprecated
    */
    class LazyLoadedValue <T> {
        constructor($$0: Internal.Supplier_<T>)
        get(): T;
    }
    type LazyLoadedValue_<T> = LazyLoadedValue<T>;
    interface SkullData {
        abstract getMesh(): Internal.Mesh;
        get mesh(): Internal.Mesh
        (): Internal.Mesh_;
    }
    type SkullData_ = SkullData;
    class ClientboundSetEntityLinkPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.Entity_, $$1: Internal.Entity_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getSourceId(): number;
        getDestId(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get sourceId(): number
        get destId(): number
        get skippable(): boolean
    }
    type ClientboundSetEntityLinkPacket_ = ClientboundSetEntityLinkPacket;
    interface OwoBufferBuilderExtension {
        abstract owo$skipNextBegin(): void;
        (): void;
    }
    type OwoBufferBuilderExtension_ = OwoBufferBuilderExtension;
    interface SimpleFluidloggedBlock extends Internal.BucketPickup, Internal.LiquidBlockContainer {
        canPlaceLiquid(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, fluid: Internal.Fluid_): boolean;
        pickupBlock(level: Internal.LevelAccessor_, pos: BlockPos_, state: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        placeLiquid(level: Internal.LevelAccessor_, pos: BlockPos_, state: Internal.BlockState_, fluidState: Internal.FluidState_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        readonly LAVALOGGED: Internal.BooleanProperty;
        readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type SimpleFluidloggedBlock_ = SimpleFluidloggedBlock;
    interface ModelPartAccessor {
        abstract flywheel$children(): Internal.Map<string, Internal.ModelPart>;
        abstract flywheel$compile(arg0: Internal.PoseStack$Pose_, arg1: Internal.VertexConsumer_, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): void;
    }
    type ModelPartAccessor_ = ModelPartAccessor;
    class ModelBakery$BakedCacheKey extends Internal.Record {
        constructor($$0: ResourceLocation_, $$1: Internal.Transformation_, $$2: boolean)
        isUvLocked(): boolean;
        id(): ResourceLocation;
        transformation(): Internal.Transformation;
        get uvLocked(): boolean
    }
    type ModelBakery$BakedCacheKey_ = ModelBakery$BakedCacheKey;
    interface PlayerRideableJumping extends Internal.PlayerRideable {
        abstract handleStopJump(): void;
        abstract onPlayerJump(arg0: number): void;
        getJumpCooldown(): number;
        abstract handleStartJump(arg0: number): void;
        abstract canJump(): boolean;
        get jumpCooldown(): number
    }
    type PlayerRideableJumping_ = PlayerRideableJumping;
    class ClientboundGameEventPacket$Type {
        constructor($$0: number)
    }
    type ClientboundGameEventPacket$Type_ = ClientboundGameEventPacket$Type;
    class CarpetBlockBuilder extends Internal.ShapedBlockBuilder {
        constructor(i: ResourceLocation_)
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        createObject(): any;
        texture(texture: string): this;
    }
    type CarpetBlockBuilder_ = CarpetBlockBuilder;
    class VegetationPatchFeature extends Internal.Feature<Internal.VegetationPatchConfiguration> {
        constructor($$0: Internal.Codec_<Internal.VegetationPatchConfiguration>)
    }
    type VegetationPatchFeature_ = VegetationPatchFeature;
    class Long2ObjectLinkedOpenHashMap <V> extends Internal.AbstractLong2ObjectSortedMap<V> implements Internal.Cloneable, Internal.Hash, Internal.Serializable {
        constructor(arg0: Internal.Long2ObjectMap_<V>)
        constructor()
        constructor(arg0: Internal.Map_<number, V>)
        constructor(arg0: number[], arg1: V[], arg2: number)
        constructor(arg0: Internal.Map_<number, V>, arg1: number)
        constructor(arg0: number)
        constructor(arg0: number[], arg1: V[])
        constructor(arg0: number, arg1: number)
        constructor(arg0: Internal.Long2ObjectMap_<V>, arg1: number)
        subMap(arg0: number, arg1: number): Internal.Long2ObjectSortedMap<V>;
        remove(arg0: number): V;
        trim(arg0: number): boolean;
        sequencedEntrySet(): Internal.SequencedSet<Internal.Map$Entry<number, V>>;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2ObjectFunction<V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        long2ObjectEntrySet(): Internal.Long2ObjectSortedMap$FastSortedEntrySet<V>;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Long2ObjectFunction<T>;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Long2LongFunction;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        firstEntry(): Internal.Map$Entry<number, V>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        sequencedValues(): Internal.SequencedCollection<V>;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Long2FloatFunction;
        values(): Internal.Collection<any>;
        composeLong(arg0: Internal.Long2LongFunction_): Internal.Long2ObjectFunction<V>;
        trim(): boolean;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Long2ShortFunction;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        merge(arg0: number, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        getAndMoveToLast(arg0: number): V;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        abstract defaultReturnValue(): V;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        clone(): any;
        tailMap(arg0: number): Internal.Long2ObjectSortedMap<V>;
        compute(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        lastEntry(): Internal.Map$Entry<number, V>;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2ObjectFunction<V>;
        static of<K, V>(): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        headMap(arg0: number): Internal.Long2ObjectSortedMap<V>;
        /**
         * @deprecated
        */
        firstKey(): any;
        /**
         * @deprecated
        */
        tailMap(arg0: number): Internal.Long2ObjectSortedMap<V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Long2ByteFunction;
        put(arg0: number, arg1: V): V;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2ObjectFunction<V>;
        compute(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        putFirst(arg0: number, arg1: V): V;
        getAndMoveToFirst(arg0: number): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        merge(arg0: number, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        entrySet(): Internal.ObjectSortedSet<Internal.Map$Entry<number, V>>;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2ObjectFunction<V>;
        replace(arg0: number, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Long2ReferenceFunction<T>;
        reversed(): Internal.SortedMap<number, V>;
        replace(arg0: number, arg1: V): V;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        removeLast(): V;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2ObjectFunction<V>;
        /**
         * @deprecated
        */
        lastKey(): any;
        computeIfPresent(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Long2IntFunction;
        putAndMoveToFirst(arg0: number, arg1: V): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        computeIfAbsent(arg0: number, arg1: Internal.LongFunction_<V>): V;
        /**
         * @deprecated
        */
        subMap(arg0: any, arg1: any): Internal.SortedMap<any, any>;
        computeIfPresent(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        apply(arg0: number): V;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        sequencedKeySet(): Internal.SequencedSet<number>;
        /**
         * @deprecated
        */
        headMap(arg0: number): Internal.Long2ObjectSortedMap<V>;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2ObjectFunction<V>;
        putIfAbsent(arg0: number, arg1: V): V;
        getOrDefault(arg0: number, arg1: V): V;
        static identity<T>(): Internal.Function<T, T>;
        forEach(arg0: Internal.BiConsumer_<number, V>): void;
        computeIfAbsent(arg0: number, arg1: Internal.Function_<number, V>): V;
        /**
         * @deprecated
        */
        computeIfAbsentPartial(arg0: number, arg1: Internal.Long2ObjectFunction_<V>): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        pollFirstEntry(): Internal.Map$Entry<number, V>;
        keySet(): Internal.LongSet;
        replace(arg0: number, arg1: V, arg2: V): boolean;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        computeIfAbsent(arg0: number, arg1: Internal.Long2ObjectFunction_<V>): V;
        apply(arg0: number): V;
        replaceAll(arg0: Internal.BiFunction_<number, V, V>): void;
        removeFirst(): V;
        putLast(arg0: number, arg1: V): V;
        /**
         * @deprecated
        */
        subMap(arg0: number, arg1: number): Internal.Long2ObjectSortedMap<V>;
        /**
         * @deprecated
        */
        tailMap(arg0: any): Internal.SortedMap<any, any>;
        putAndMoveToLast(arg0: number, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        headMap(arg0: any): Internal.SortedMap<any, any>;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Long2DoubleFunction;
        get(arg0: number): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        pollLastEntry(): Internal.Map$Entry<number, V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Long2CharFunction;
        putIfAbsent(arg0: number, arg1: V): V;
    }
    type Long2ObjectLinkedOpenHashMap_<V> = Long2ObjectLinkedOpenHashMap<V>;
    interface UserApiService {
        abstract reportAbuse(arg0: Internal.AbuseReportRequest_): void;
        abstract isBlockedPlayer(arg0: Internal.UUID_): boolean;
        abstract canSendReports(): boolean;
        abstract getAbuseReportLimits(): Internal.AbuseReportLimits;
        abstract properties(): Internal.UserApiService$UserProperties;
        abstract newTelemetrySession(arg0: Internal.Executor_): Internal.TelemetrySession;
        abstract getKeyPair(): Internal.KeyPairResponse;
        abstract refreshBlockList(): void;
        get abuseReportLimits(): Internal.AbuseReportLimits
        get keyPair(): Internal.KeyPairResponse
        readonly OFFLINE: Internal.UserApiService;
        readonly OFFLINE_PROPERTIES: Internal.UserApiService$UserProperties;
    }
    type UserApiService_ = UserApiService;
    class LargeDripstoneConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: number, $$1: Internal.IntProvider_, $$2: Internal.FloatProvider_, $$3: number, $$4: Internal.FloatProvider_, $$5: Internal.FloatProvider_, $$6: Internal.FloatProvider_, $$7: number, $$8: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly floorToCeilingSearchRange: number;
        readonly columnRadius: Internal.IntProvider;
        readonly stalactiteBluntness: Internal.FloatProvider;
        readonly minBluntnessForWind: number;
        static readonly CODEC: Internal.Codec<Internal.LargeDripstoneConfiguration>;
        readonly minRadiusForWind: number;
        readonly heightScale: Internal.FloatProvider;
        readonly windSpeed: Internal.FloatProvider;
        readonly maxColumnRadiusToCaveHeightRatio: number;
        readonly stalagmiteBluntness: Internal.FloatProvider;
    }
    type LargeDripstoneConfiguration_ = LargeDripstoneConfiguration;
    class ChuteBlock$Shape extends Internal.Enum<Internal.ChuteBlock$Shape> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.ChuteBlock$Shape[];
        static valueOf(name: string): Internal.ChuteBlock$Shape;
        get serializedName(): string
        static readonly WINDOW: Internal.ChuteBlock$Shape;
        static readonly ENCASED: Internal.ChuteBlock$Shape;
        static readonly INTERSECTION: Internal.ChuteBlock$Shape;
        static readonly NORMAL: Internal.ChuteBlock$Shape;
    }
    type ChuteBlock$Shape_ = "normal" | "window" | ChuteBlock$Shape | "intersection" | "encased";
    interface Matrix4x3dc {
        abstract get4x4(arg0: number[]): number[];
        abstract mapnYXnZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapXZnY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract translateLocal(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapZnYnX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
        abstract transform(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract m20(): number;
        abstract mapnZXY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
        abstract origin(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract negateY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract fma(arg0: Internal.Matrix4x3dc_, arg1: number, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract translateLocal(arg0: Internal.Vector3dc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract transformDirection(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnZnYnX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        abstract normal(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnXZY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract scale(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract positiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract m31(): number;
        abstract arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getTranslation(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract normal(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapYXnZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapYnXnZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract reflect(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract normalize3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract rotate(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mulTranslation(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract normalize3x3(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get4x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract rotateAround(arg0: Internal.Quaterniondc_, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract rotateX(arg0: number, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get4x4(arg0: number[], arg1: number): number[];
        abstract scale(arg0: Internal.Vector3dc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract negateZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnYnXnZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract rotate(arg0: Internal.AxisAngle4d_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapZXY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mul(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract lookAlong(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract obliqueZ(arg0: number, arg1: number, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract m30(): number;
        abstract reflect(arg0: Internal.Quaterniondc_, arg1: Internal.Vector3dc_, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract positiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformAab(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3d_, arg3: Internal.Vector3d_): Internal.Matrix4x3d;
        abstract mapnXnZY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get4x4(arg0: number[]): number[];
        abstract orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapYnXZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract cofactor3x3(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract rotate(arg0: number, arg1: Internal.Vector3dc_, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract transpose3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract translate(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract isFinite(): boolean;
        abstract rotateY(arg0: number, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapXnZY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapXnZnY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getToAddress(arg0: number): this;
        abstract add(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract lerp(arg0: Internal.Matrix4x3dc_, arg1: number, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapYZX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnYZnX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract scaleXY(arg0: number, arg1: number, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnXnZnY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mapnZYX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapZnXY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnXZnY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnYXZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get(arg0: number[], arg1: number): number[];
        abstract rotateTranslation(arg0: Internal.Quaterniondc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract negateX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract rotateZ(arg0: number, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract m02(): number;
        abstract get4x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract lookAt(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_, arg3: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract invertOrtho(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract transformPosition(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract mapZYnX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
        abstract get4x4(arg0: number[], arg1: number): number[];
        abstract mapXZY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract sub(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract shadow(arg0: Internal.Vector4dc_, arg1: Internal.Matrix4x3dc_, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnXYnZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract arcball(arg0: number, arg1: Internal.Vector3dc_, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapYnZnX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnZnYX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnXnYnZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract rotate(arg0: Internal.Quaterniondc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract scale(arg0: number, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnYnZnX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get4x4(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mapnYnZX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract m01(): number;
        abstract mapnZnXY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapZXnY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3dc_, arg5: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get(arg0: number[]): number[];
        abstract mul(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapYZnX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapXnYnZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnZXnY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract m12(): number;
        abstract get(arg0: number[], arg1: number): number[];
        abstract rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract m00(): number;
        abstract equals(arg0: Internal.Matrix4x3dc_, arg1: number): boolean;
        abstract rotateLocal(arg0: Internal.Quaterniondc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get(arg0: number[]): number[];
        abstract determinant(): number;
        abstract properties(): number;
        abstract invert(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract translateLocal(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract normalizedPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract getTransposed(arg0: number[], arg1: number): number[];
        abstract rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getTransposedFloats(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract getEulerAnglesZYX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract getColumn(arg0: number, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getFloats(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract getTransposed(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract transformDirection(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract m11(): number;
        abstract translate(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get4x4(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract mulOrtho(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getTransposed(arg0: number[]): number[];
        abstract cofactor3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract mapnYZX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Vector3d_, arg7: Internal.Vector3d_): Internal.Matrix4x3d;
        abstract getRow(arg0: number, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract transpose3x3(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mulTranslation(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract m22(): number;
        abstract getTransposedFloats(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract rotateLocal(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapYXZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract get(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract mapZnXnY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract normalizedPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract mulComponentWise(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getScale(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract sub(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract shadow(arg0: Internal.Vector4dc_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract m10(): number;
        abstract get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract lookAtLH(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_, arg3: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract translate(arg0: Internal.Vector3dc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getTransposed(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract mapnYnXZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapYnZX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getEulerAnglesXYZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract m21(): number;
        abstract orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapZnYX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract frustumPlane(arg0: number, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract add(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        abstract mapnZYnX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnXnYZ(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract rotateTowards(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract rotate(arg0: Internal.AxisAngle4f_, arg1: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getFloats(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract normalizedPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformPosition(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract m32(): number;
        abstract positiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract fma(arg0: Internal.Matrix4x3fc_, arg1: number, arg2: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapZYX(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract mapnZnXnY(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        get finite(): boolean
        readonly PLANE_PX: 1;
        readonly PLANE_NY: 2;
        readonly PLANE_NZ: 4;
        readonly PLANE_PY: 3;
        readonly PLANE_NX: 0;
        readonly PLANE_PZ: 5;
        readonly PROPERTY_TRANSLATION: 8;
        readonly PROPERTY_IDENTITY: 4;
        readonly PROPERTY_ORTHONORMAL: 16;
    }
    type Matrix4x3dc_ = Matrix4x3dc;
    class BeltFunnelBlock$Shape extends Internal.Enum<Internal.BeltFunnelBlock$Shape> implements Internal.StringRepresentable {
        static values(): Internal.BeltFunnelBlock$Shape[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(name: string): Internal.BeltFunnelBlock$Shape;
        get serializedName(): string
        static readonly EXTENDED: Internal.BeltFunnelBlock$Shape;
        static readonly PUSHING: Internal.BeltFunnelBlock$Shape;
        static readonly RETRACTED: Internal.BeltFunnelBlock$Shape;
        static readonly PULLING: Internal.BeltFunnelBlock$Shape;
    }
    type BeltFunnelBlock$Shape_ = "extended" | "pulling" | "retracted" | "pushing" | BeltFunnelBlock$Shape;
    class KeyCompressor <T> {
        constructor(arg0: Internal.DynamicOps_<T>, arg1: Internal.Stream_<T>)
        size(): number;
        compress(arg0: T): number;
        decompress(arg0: number): T;
        compress(arg0: string): number;
    }
    type KeyCompressor_<T> = KeyCompressor<T>;
    class WallBlockBuilder extends Internal.MultipartShapedBlockBuilder {
        constructor(i: ResourceLocation_)
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        createObject(): any;
    }
    type WallBlockBuilder_ = WallBlockBuilder;
    class WorldGenerationContext {
        constructor($$0: Internal.ChunkGenerator_, $$1: Internal.LevelHeightAccessor_)
        getGenDepth(): number;
        getMinGenY(): number;
        get genDepth(): number
        get minGenY(): number
    }
    type WorldGenerationContext_ = WorldGenerationContext;
    interface BlockStateBlockItemGroup$IStyle <T> {
        abstract getLangName(arg0: T): string;
        abstract getModel(arg0: T): ResourceLocation;
        abstract getBlockId(arg0: T): string;
    }
    type BlockStateBlockItemGroup$IStyle_<T> = BlockStateBlockItemGroup$IStyle<T>;
    class ToolBuildingRecipeSerializer extends Internal.LoggingRecipeSerializer<Internal.ToolBuildingRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(recipeId: ResourceLocation_, json: Internal.JsonObject_): Internal.ToolBuildingRecipe;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
    }
    type ToolBuildingRecipeSerializer_ = ToolBuildingRecipeSerializer;
    interface SortedSet <E> extends Internal.SequencedSet<E>, Internal.Set<E> {
        addLast(arg0: E): void;
        getLast(): E;
        abstract subSet(arg0: E, arg1: E): this;
        abstract add(arg0: E): boolean;
        removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        abstract isEmpty(): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        abstract comparator(): Internal.Comparator<E>;
        of<E>(arg0: E, arg1: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        abstract contains(arg0: any): boolean;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        abstract last(): E;
        abstract tailSet(arg0: E): this;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        addFirst(arg0: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        reversed(): Internal.SequencedSet<any>;
        abstract toArray<T>(arg0: T[]): T[];
        abstract headSet(arg0: E): this;
        abstract remove(arg0: any): boolean;
        abstract toArray(): any[];
        getFirst(): E;
        abstract iterator(): Internal.Iterator<E>;
        abstract size(): number;
        abstract hashCode(): number;
        of<E>(arg0: E): Internal.Set<E>;
        of<E>(): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        of<E>(...arg0: E[]): Internal.Set<E>;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        abstract first(): E;
        abstract clear(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        spliterator(): Internal.Spliterator<E>;
        removeLast(): E;
        abstract equals(arg0: any): boolean;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        get last(): E
        get empty(): boolean
        get first(): E
    }
    type SortedSet_<E> = SortedSet<E>;
    class RecordCodecBuilder$Instance <O> implements Internal.Applicative<Internal.RecordCodecBuilder$Mu<O>, any> {
        constructor()
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>, arg11: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T12>, arg12: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T13>, arg13: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T14>): Internal.Products$P14<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>;
        apply2<A, B, R>(arg0: Internal.BiFunction_<A, B, R>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, A>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, B>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>): Internal.Products$P10<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>;
        group<T1, T2>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>): Internal.Products$P2<Internal.RecordCodecBuilder$Mu<O>, T1, T2>;
        lift8<T1, T2, T3, T4, T5, T6, T7, T8, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function8<T1, T2, T3, T4, T5, T6, T7, T8, R>>): Internal.Function8<Internal.App<Internal.RecordCodecBuilder$Mu<O>, T1>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T2>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T3>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T4>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T5>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T6>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T7>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T8>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>>;
        ap4<T1, T2, T3, T4, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function4<T1, T2, T3, T4, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        lift9<T1, T2, T3, T4, T5, T6, T7, T8, T9, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, R>>): Internal.Function9<Internal.App<Internal.RecordCodecBuilder$Mu<O>, T1>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T2>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T3>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T4>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T5>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T6>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T7>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T8>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T9>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>>;
        ap3<T1, T2, T3, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function3<T1, T2, T3, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        lift2<A, B, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.BiFunction<A, B, R>>): Internal.BiFunction<Internal.App<Internal.RecordCodecBuilder$Mu<O>, A>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, B>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>, arg11: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T12>, arg12: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T13>, arg13: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T14>, arg14: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T15>): Internal.Products$P15<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>;
        apply4<T1, T2, T3, T4, R>(arg0: Internal.Function4_<T1, T2, T3, T4, R>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>): Internal.Products$P11<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>;
        apply8<T1, T2, T3, T4, T5, T6, T7, T8, R>(arg0: Internal.Function8_<T1, T2, T3, T4, T5, T6, T7, T8, R>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        ap5<T1, T2, T3, T4, T5, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function5<T1, T2, T3, T4, T5, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        apply9<T1, T2, T3, T4, T5, T6, T7, T8, T9, R>(arg0: Internal.Function9_<T1, T2, T3, T4, T5, T6, T7, T8, T9, R>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        ap6<T1, T2, T3, T4, T5, T6, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function6<T1, T2, T3, T4, T5, T6, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        lift6<T1, T2, T3, T4, T5, T6, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function6<T1, T2, T3, T4, T5, T6, R>>): Internal.Function6<Internal.App<Internal.RecordCodecBuilder$Mu<O>, T1>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T2>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T3>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T4>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T5>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T6>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>>;
        ap16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg11: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>, arg12: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T12>, arg13: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T13>, arg14: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T14>, arg15: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T15>, arg16: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T16>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        ap11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg11: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        group<T1, T2, T3>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>): Internal.Products$P3<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3>;
        static unbox<F extends Internal.K1, Mu extends Internal.Applicative$Mu>(arg0: Internal.App_<Mu, F>): Internal.Applicative<F, Mu>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>): Internal.Products$P9<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5, T6, T7, T8, T9>;
        ap9<T1, T2, T3, T4, T5, T6, T7, T8, T9, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        apply5<T1, T2, T3, T4, T5, R>(arg0: Internal.Function5_<T1, T2, T3, T4, T5, R>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        group<T1, T2, T3, T4, T5, T6, T7>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>): Internal.Products$P7<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5, T6, T7>;
        ap13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg11: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>, arg12: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T12>, arg13: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T13>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        ap14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg11: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>, arg12: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T12>, arg13: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T13>, arg14: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T14>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        ap12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg11: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>, arg12: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T12>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        point<A>(arg0: A): Internal.App<Internal.RecordCodecBuilder$Mu<O>, A>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>, arg11: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T12>, arg12: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T13>): Internal.Products$P13<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>;
        group<T1, T2, T3, T4, T5>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>): Internal.Products$P5<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5>;
        lift1<A, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function<A, R>>): Internal.Function<Internal.App<Internal.RecordCodecBuilder$Mu<O>, A>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>>;
        apply3<T1, T2, T3, R>(arg0: Internal.Function3_<T1, T2, T3, R>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        group<T1, T2, T3, T4>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>): Internal.Products$P4<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4>;
        deprecated<A>(arg0: A, arg1: number): Internal.App<Internal.RecordCodecBuilder$Mu<O>, A>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>, arg11: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T12>, arg12: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T13>, arg13: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T14>, arg14: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T15>, arg15: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T16>): Internal.Products$P16<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>;
        ap7<T1, T2, T3, T4, T5, T6, T7, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function7<T1, T2, T3, T4, T5, T6, T7, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        stable<A>(arg0: A): Internal.App<Internal.RecordCodecBuilder$Mu<O>, A>;
        ap8<T1, T2, T3, T4, T5, T6, T7, T8, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function8<T1, T2, T3, T4, T5, T6, T7, T8, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        lift4<T1, T2, T3, T4, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function4<T1, T2, T3, T4, R>>): Internal.Function4<Internal.App<Internal.RecordCodecBuilder$Mu<O>, T1>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T2>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T3>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T4>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>>;
        ap<A, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function<A, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, A>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        point<A>(arg0: A, arg1: Internal.Lifecycle_): Internal.App<Internal.RecordCodecBuilder$Mu<O>, A>;
        ap15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg11: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>, arg12: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T12>, arg13: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T13>, arg14: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T14>, arg15: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T15>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T11>, arg11: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T12>): Internal.Products$P12<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>;
        ap<A, R>(arg0: Internal.Function_<A, R>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, A>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        group<T1, T2, T3, T4, T5, T6, T7, T8>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>): Internal.Products$P8<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5, T6, T7, T8>;
        lift5<T1, T2, T3, T4, T5, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function5<T1, T2, T3, T4, T5, R>>): Internal.Function5<Internal.App<Internal.RecordCodecBuilder$Mu<O>, T1>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T2>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T3>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T4>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T5>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>>;
        lift7<T1, T2, T3, T4, T5, T6, T7, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function7<T1, T2, T3, T4, T5, T6, T7, R>>): Internal.Function7<Internal.App<Internal.RecordCodecBuilder$Mu<O>, T1>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T2>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T3>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T4>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T5>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T6>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T7>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>>;
        ap10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>, arg8: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T8>, arg9: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T9>, arg10: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T10>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        map<T, R>(arg0: Internal.Function_<T, R>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        apply7<T1, T2, T3, T4, T5, T6, T7, R>(arg0: Internal.Function7_<T1, T2, T3, T4, T5, T6, T7, R>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>, arg7: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T7>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        lift3<T1, T2, T3, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.Function3<T1, T2, T3, R>>): Internal.Function3<Internal.App<Internal.RecordCodecBuilder$Mu<O>, T1>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T2>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, T3>, Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>>;
        group<T1, T2, T3, T4, T5, T6>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>): Internal.Products$P6<Internal.RecordCodecBuilder$Mu<O>, T1, T2, T3, T4, T5, T6>;
        apply6<T1, T2, T3, T4, T5, T6, R>(arg0: Internal.Function6_<T1, T2, T3, T4, T5, T6, R>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T2>, arg3: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T3>, arg4: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T4>, arg5: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T5>, arg6: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T6>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        ap2<A, B, R>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, Internal.BiFunction<A, B, R>>, arg1: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, A>, arg2: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, B>): Internal.App<Internal.RecordCodecBuilder$Mu<O>, R>;
        group<T1>(arg0: Internal.App_<Internal.RecordCodecBuilder$Mu<O>, T1>): Internal.Products$P1<Internal.RecordCodecBuilder$Mu<O>, T1>;
    }
    type RecordCodecBuilder$Instance_<O> = RecordCodecBuilder$Instance<O>;
    class DragonScaleItem extends Internal.TooltipItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DragonScaleItem_ = DragonScaleItem;
    class AllArmInteractionPointTypes$PackagerType extends Internal.ArmInteractionPointType {
        constructor()
    }
    type AllArmInteractionPointTypes$PackagerType_ = AllArmInteractionPointTypes$PackagerType;
    interface IChestOrDrive extends Internal.IActionHost {
        abstract getActionableNode(): Internal.IGridNode;
        abstract getCellCount(): number;
        abstract getOriginalCellInventory(arg0: number): Internal.StorageCell;
        abstract isCellBlinking(arg0: number): boolean;
        abstract getCellItem(arg0: number): Internal.Item;
        abstract getCellInventory(arg0: number): Internal.MEStorage;
        abstract getCellStatus(arg0: number): Internal.CellState;
        abstract isPowered(): boolean;
        get actionableNode(): Internal.IGridNode
        get cellCount(): number
        get powered(): boolean
    }
    type IChestOrDrive_ = IChestOrDrive;
    class LootBuilderPool implements Internal.FunctionContainer, Internal.ConditionContainer {
        constructor()
        addCondition(o: Internal.JsonObject_): this;
        setUniformRolls(min: number, max: number): void;
        randomChanceWithLooting(chance: number, multiplier: number): Internal.ConditionContainer;
        name(name: net.minecraft.network.chat.Component_, entity: Internal.LootContext$EntityTarget_): Internal.FunctionContainer;
        toJson(): Internal.JsonObject;
        damage(damage: Internal.NumberProvider_): Internal.FunctionContainer;
        count(count: Internal.NumberProvider_): Internal.FunctionContainer;
        survivesExplosion(): Internal.ConditionContainer;
        addTag(tag: string, expand: boolean): Internal.LootTableEntry;
        addFunction(o: Internal.JsonObject_): this;
        addItem(item: Internal.ItemStack_, weight: number, count: Internal.NumberProvider_): Internal.LootTableEntry;
        copyName(source: Internal.CopyNameFunction$NameSource_): Internal.FunctionContainer;
        lootTable(table: ResourceLocation_, seed: number): Internal.FunctionContainer;
        addItem(item: Internal.ItemStack_): Internal.LootTableEntry;
        enchantWithLevels(levels: Internal.NumberProvider_, treasure: boolean): Internal.FunctionContainer;
        enchantRandomly(enchantments: ResourceLocation_[]): Internal.FunctionContainer;
        addEntry(json: Internal.JsonObject_): Internal.LootTableEntry;
        furnaceSmelt(): Internal.FunctionContainer;
        entityProperties(entity: Internal.LootContext$EntityTarget_, properties: Internal.JsonObject_): Internal.ConditionContainer;
        lootingEnchant(count: Internal.NumberProvider_, limit: number): Internal.FunctionContainer;
        addEmpty(weight: number): Internal.LootTableEntry;
        addConditionalFunction(func: Internal.Consumer_<Internal.ConditionalFunction>): Internal.FunctionContainer;
        randomChance(chance: number): Internal.ConditionContainer;
        addLootTable(table: ResourceLocation_): Internal.LootTableEntry;
        setBinomialRolls(n: number, p: number): void;
        killedByPlayer(): Internal.ConditionContainer;
        nbt(tag: Internal.CompoundTag_): Internal.FunctionContainer;
        entityScores(entity: Internal.LootContext$EntityTarget_, scores: Internal.Map_<string, any>): Internal.ConditionContainer;
        addItem(item: Internal.ItemStack_, weight: number): Internal.LootTableEntry;
        name(name: net.minecraft.network.chat.Component_): Internal.FunctionContainer;
        rolls: Internal.NumberProvider;
        readonly entries: Internal.JsonArray;
        readonly conditions: Internal.JsonArray;
        bonusRolls: Internal.NumberProvider;
        readonly functions: Internal.JsonArray;
    }
    type LootBuilderPool_ = LootBuilderPool;
    class PiecesContainer extends Internal.Record {
        constructor($$0: Internal.List_<Internal.StructurePiece>)
        pieces(): Internal.List<Internal.StructurePiece>;
        isInsidePiece($$0: BlockPos_): boolean;
        static load($$0: Internal.ListTag_, $$1: Internal.StructurePieceSerializationContext_): Internal.PiecesContainer;
        save($$0: Internal.StructurePieceSerializationContext_): Internal.Tag;
        calculateBoundingBox(): Internal.BoundingBox;
        isEmpty(): boolean;
        get empty(): boolean
    }
    type PiecesContainer_ = PiecesContainer;
    class NephthysSpecialHandler$Factory implements Internal.SpecialHandler$Factory<Internal.NephthysSpecialHandler> {
        constructor()
        tryMatch(pattern: Internal.HexPattern_, env: Internal.CastingEnvironment_): Internal.NephthysSpecialHandler;
    }
    type NephthysSpecialHandler$Factory_ = NephthysSpecialHandler$Factory;
    class AbstractTickableTile <V extends Internal.IVariant<any>, B extends Internal.AbstractBlock<V, B>> extends Internal.AbstractTileEntity<V, B> {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_, variant: V)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        sync(delay: number): void;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        tick(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        nextRedstoneMode(): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        onAdded(world: Internal.Level_, state: Internal.BlockState_, oldState: Internal.BlockState_, isMoving: boolean): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        ticks: number;
    }
    type AbstractTickableTile_<V extends Internal.IVariant<any>, B extends Internal.AbstractBlock<V, B>> = AbstractTickableTile<V, B>;
    class MoltenMercuryFluid$Source extends Internal.MoltenMercuryFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenMercuryFluid$Source_ = MoltenMercuryFluid$Source;
    class DragonChargePlayerPhase extends Internal.AbstractDragonPhaseInstance {
        constructor($$0: Internal.EnderDragon_)
        getPhase(): Internal.EnderDragonPhase<Internal.DragonChargePlayerPhase>;
        setTarget($$0: Vec3d_): void;
        get phase(): Internal.EnderDragonPhase<Internal.DragonChargePlayerPhase>
        set target($$0: Vec3d_)
    }
    type DragonChargePlayerPhase_ = DragonChargePlayerPhase;
    class HeadstockStyle extends Internal.Enum<Internal.HeadstockStyle> implements Internal.BlockStateBlockItemGroup$IStyle<boolean>, Internal.StringRepresentable {
        getBlockId(context: boolean): string;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.HeadstockStyle[];
        getSerializedName(): string;
        getBlockId(arg0: any): string;
        getModel(arg0: any): ResourceLocation;
        getLangName(copycat: boolean): string;
        getModel(context: boolean): ResourceLocation;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        getLangName(arg0: any): string;
        getModel(copycat: boolean, upsideDown: boolean): ResourceLocation;
        static valueOf(name: string): Internal.HeadstockStyle;
        get serializedName(): string
        static readonly BUFFER: Internal.HeadstockStyle;
        static readonly KNUCKLE: Internal.HeadstockStyle;
        static readonly KNUCKLE_SPLIT: Internal.HeadstockStyle;
        static readonly SCREWLINK: Internal.HeadstockStyle;
        static readonly LINKLESS: Internal.HeadstockStyle;
        static readonly PLAIN: Internal.HeadstockStyle;
        static readonly LINK: Internal.HeadstockStyle;
    }
    type HeadstockStyle_ = "knuckle_split" | "screwlink" | "plain" | HeadstockStyle | "linkless" | "link" | "buffer" | "knuckle";
    class Object2IntOpenHashMap <K> extends Internal.AbstractObject2IntMap<K> implements Internal.Cloneable, Internal.Hash, Internal.Serializable {
        constructor(arg0: K[], arg1: number[], arg2: number)
        constructor()
        constructor(arg0: Internal.Object2IntMap_<K>, arg1: number)
        constructor(arg0: Internal.Map_<K, number>, arg1: number)
        constructor(arg0: K[], arg1: number[])
        constructor(arg0: Internal.Object2IntMap_<K>)
        constructor(arg0: number)
        constructor(arg0: Internal.Map_<K, number>)
        constructor(arg0: number, arg1: number)
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2IntFunction<T>;
        /**
         * @deprecated
        */
        mergeInt(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        /**
         * @deprecated
        */
        containsValue(arg0: any): boolean;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        trim(arg0: number): boolean;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2IntFunction;
        apply(arg0: K): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2IntFunction;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: K, arg1: number): number;
        clone(): this;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any, arg2: any): boolean;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        computeIntIfAbsentPartial(arg0: K, arg1: Internal.Object2IntFunction_<K>): number;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        trim(): boolean;
        andThenInt(arg0: Internal.Int2IntFunction_): Internal.Object2IntFunction<K>;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        replaceAll(arg0: Internal.BiFunction_<K, number, number>): void;
        applyAsInt(arg0: K): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Object2ByteFunction<K>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        static identity<T>(): Internal.Function<T, T>;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: any, arg1: any): any;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        object2IntEntrySet(): Internal.Object2IntMap$FastEntrySet<K>;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Object2FloatFunction<K>;
        addTo(arg0: K, arg1: number): number;
        /**
         * @deprecated
        */
        computeIntIfAbsent(arg0: K, arg1: Internal.ToIntFunction_<K>): number;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Object2LongFunction<K>;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2IntFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        static of<K, V>(): Internal.Map<K, V>;
        mergeInt(arg0: K, arg1: number, arg2: Internal.IntBinaryOperator_): number;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        /**
         * @deprecated
        */
        merge(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number): number;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Object2ShortFunction<K>;
        /**
         * @deprecated
        */
        entrySet(): Internal.ObjectSet<Internal.Map$Entry<K, number>>;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number, arg2: number): boolean;
        keySet(): Internal.ObjectSet<K>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        remove(arg0: any, arg1: any): boolean;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2IntFunction;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2IntFunction;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2IntFunction;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any): any;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Object2CharFunction<K>;
        /**
         * @deprecated
        */
        merge(arg0: any, arg1: any, arg2: Internal.BiFunction_<any, any, any>): any;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2IntFunction;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, number>): number;
        forEach(arg0: Internal.BiConsumer_<K, number>): void;
    }
    type Object2IntOpenHashMap_<K> = Object2IntOpenHashMap<K>;
    interface ToLongFunction <T> {
        abstract applyAsLong(arg0: T): number;
        (arg0: T): number;
    }
    type ToLongFunction_<T> = ToLongFunction<T>;
    class SequencedAssemblyRecipe implements Internal.Recipe<net.minecraft.world.Container> {
        constructor(recipeId: ResourceLocation_, serializer: Internal.SequencedAssemblyRecipeSerializer_)
        static getRecipe<C extends net.minecraft.world.Container, R extends Internal.ProcessingRecipe<C>>(world: Internal.Level_, inv: C, type: Internal.RecipeType_<R>, recipeClass: R, recipeFilter: Internal.Predicate_<R>): Internal.Optional<R>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getOutputChance(): number;
        getLoops(): number;
        getTransitionalItem(): Internal.ItemStack;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(inv: net.minecraft.world.Container_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        static getRecipe<C extends net.minecraft.world.Container, R extends Internal.ProcessingRecipe<C>>(world: Internal.Level_, inv: C, type: Internal.RecipeType_<R>, recipeClass: R): Internal.Optional<R>;
        static getRecipe<R extends Internal.ProcessingRecipe<any>>(world: Internal.Level_, item: Internal.ItemStack_, type: Internal.RecipeType_<R>, recipeClass: R): Internal.Optional<R>;
        getSequence(): Internal.List<Internal.SequencedRecipe<any>>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(inv: net.minecraft.world.Container_, p_77569_2_: Internal.Level_): boolean;
        getIngredient(): Internal.Ingredient;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        addAdditionalIngredientsAndMachines(list: Internal.List_<Internal.Ingredient>): void;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        canCraftInDimensions(p_194133_1_: number, p_194133_2_: number): boolean;
        addAdditionalFluidIngredients(list: Internal.List_<Internal.FluidIngredient>): void;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        static getRecipes<R extends Internal.ProcessingRecipe<any>>(world: Internal.Level_, item: Internal.ItemStack_, type: Internal.RecipeType_<R>, recipeClass: R): Internal.Stream<R>;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        static addToTooltip(stack: Internal.ItemStack_, tooltip: Internal.List_<net.minecraft.network.chat.Component>): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get outputChance(): number
        get loops(): number
        get transitionalItem(): Internal.ItemStack
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get sequence(): Internal.List<Internal.SequencedRecipe<any>>
        get ingredient(): Internal.Ingredient
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        readonly resultPool: Internal.List<Internal.ProcessingOutput>;
    }
    type SequencedAssemblyRecipe_ = SequencedAssemblyRecipe;
    class ImmutableSetMultimap <K, V> extends Internal.ImmutableMultimap<K, V> implements Internal.SetMultimap<K, V> {
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.ImmutableSetMultimap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.ImmutableSetMultimap<K, V>;
        static copyOf<K, V>(arg0: Internal.Iterable_<Internal.Map$Entry<K, V>>): Internal.ImmutableSetMultimap<K, V>;
        /**
         * @deprecated
        */
        replaceValues(arg0: any, arg1: Internal.Iterable_<any>): Internal.Collection<any>;
        static builder<K, V>(): Internal.ImmutableSetMultimap$Builder<K, V>;
        static flatteningToImmutableSetMultimap<T, K, V>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, Internal.Stream<V>>): Internal.Collector<T, any, Internal.ImmutableSetMultimap<K, V>>;
        entries(): Internal.Collection<any>;
        inverse(): Internal.ImmutableMultimap<any, any>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.ImmutableSetMultimap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.ImmutableSetMultimap<K, V>;
        static toImmutableSetMultimap<T, K, V>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, V>): Internal.Collector<T, any, Internal.ImmutableSetMultimap<K, V>>;
        get(arg0: any): Internal.Collection<any>;
        /**
         * @deprecated
        */
        removeAll(arg0: any): Internal.Set<any>;
        static of<K, V>(arg0: K, arg1: V): Internal.ImmutableSetMultimap<K, V>;
        static copyOf<K, V>(arg0: Internal.Multimap_<K, V>): Internal.ImmutableSetMultimap<K, V>;
        keys(): Internal.Multiset<any>;
        abstract asMap(): Internal.Map<K, Internal.Collection<V>>;
        static of<K, V>(): Internal.ImmutableSetMultimap<K, V>;
        values(): Internal.Collection<any>;
    }
    type ImmutableSetMultimap_<K, V> = ImmutableSetMultimap<K, V>;
    interface VoxelShapeAccess {
        abstract getFaces(): Internal.VoxelShape[];
        abstract setFaces(arg0: Internal.VoxelShape_[]): void;
        abstract getShape(): Internal.DiscreteVoxelShape;
        abstract setShape(arg0: Internal.DiscreteVoxelShape_): void;
        get faces(): Internal.VoxelShape[]
        set faces(arg0: Internal.VoxelShape_[])
        get shape(): Internal.DiscreteVoxelShape
        set shape(arg0: Internal.DiscreteVoxelShape_)
    }
    type VoxelShapeAccess_ = VoxelShapeAccess;
    interface DefaultedRegistry <T> extends Internal.Registry<T> {
        asHolderIdMap(): Internal.IdMap<Internal.Holder<T>>;
        abstract getResourceKey(arg0: T): Internal.Optional<Internal.ResourceKey<T>>;
        abstract get(arg0: Internal.ResourceKey_<T>): T;
        abstract registryKeySet(): Internal.Set<Internal.ResourceKey<T>>;
        abstract keySet(): Internal.Set<ResourceLocation>;
        abstract getTagNames(): Internal.Stream<Internal.TagKey<T>>;
        keys<U>($$0: Internal.DynamicOps_<U>): Internal.Stream<U>;
        abstract get(arg0: ResourceLocation_): T;
        abstract key(): Internal.ResourceKey<Internal.Registry<T>>;
        abstract getTags(): Internal.Stream<com.mojang.datafixers.util.Pair<Internal.TagKey<T>, Internal.HolderSet$Named<T>>>;
        getTagOrEmpty($$0: Internal.TagKey_<T>): Internal.Iterable<Internal.Holder<T>>;
        abstract freeze(): Internal.Registry<T>;
        abstract getRandom(arg0: Internal.RandomSource_): Internal.Optional<Internal.Holder$Reference<T>>;
        abstract holderOwner(): Internal.HolderOwner<T>;
        register<V, T extends V>($$0: Internal.Registry_<V>, $$1: Internal.ResourceKey_<V>, $$2: T): T;
        abstract lifecycle(arg0: T): Internal.Lifecycle;
        registerForHolder<T>($$0: Internal.Registry_<T>, $$1: ResourceLocation_, $$2: T): Internal.Holder$Reference<T>;
        asTagAddingLookup(): Internal.HolderLookup$RegistryLookup<T>;
        abstract getOrCreateTag(arg0: Internal.TagKey_<T>): Internal.HolderSet$Named<T>;
        abstract getId(arg0: T): number;
        register<V, T extends V>($$0: Internal.Registry_<V>, $$1: ResourceLocation_, $$2: T): T;
        getOrThrow($$0: Internal.ResourceKey_<T>): T;
        byNameCodec(): Internal.Codec<T>;
        registerMapping<V, T extends V>($$0: Internal.Registry_<V>, $$1: number, $$2: string, $$3: T): T;
        getHolderOrThrow($$0: Internal.ResourceKey_<T>): Internal.Holder$Reference<T>;
        spliterator(): Internal.Spliterator<T>;
        abstract containsKey(arg0: Internal.ResourceKey_<T>): boolean;
        byIdOrThrow($$0: number): T;
        abstract containsKey(arg0: ResourceLocation_): boolean;
        abstract bindTags(arg0: Internal.Map_<Internal.TagKey<T>, Internal.List<Internal.Holder<T>>>): void;
        abstract iterator(): Internal.Iterator<T>;
        registerForHolder<T>($$0: Internal.Registry_<T>, $$1: Internal.ResourceKey_<T>, $$2: T): Internal.Holder$Reference<T>;
        forEach(arg0: Internal.Consumer_<T>): void;
        holderByNameCodec(): Internal.Codec<Internal.Holder<T>>;
        abstract getHolder(arg0: Internal.ResourceKey_<T>): Internal.Optional<Internal.Holder$Reference<T>>;
        abstract registryLifecycle(): Internal.Lifecycle;
        abstract byId(arg0: number): T;
        abstract getDefaultKey(): ResourceLocation;
        abstract createIntrusiveHolder(arg0: T): Internal.Holder$Reference<T>;
        register<T>($$0: Internal.Registry_<T>, $$1: string, $$2: T): T;
        stream(): Internal.Stream<T>;
        getOptional($$0: Internal.ResourceKey_<T>): Internal.Optional<T>;
        getOptional($$0: ResourceLocation_): Internal.Optional<T>;
        abstract getTag(arg0: Internal.TagKey_<T>): Internal.Optional<Internal.HolderSet$Named<T>>;
        forStrings(arg0: Internal.Supplier_<Internal.Stream<string>>): Internal.Keyable;
        abstract size(): number;
        abstract entrySet(): Internal.Set<Internal.Map$Entry<Internal.ResourceKey<T>, T>>;
        abstract resetTags(): void;
        abstract getHolder(arg0: number): Internal.Optional<Internal.Holder$Reference<T>>;
        abstract getKey(arg0: T): ResourceLocation;
        abstract holders(): Internal.Stream<Internal.Holder$Reference<T>>;
        abstract asLookup(): Internal.HolderLookup$RegistryLookup<T>;
        abstract wrapAsHolder(arg0: T): Internal.Holder<T>;
        get tagNames(): Internal.Stream<Internal.TagKey<T>>
        get tags(): Internal.Stream<com.mojang.datafixers.util.Pair<Internal.TagKey<T>, Internal.HolderSet$Named<T>>>
        get defaultKey(): ResourceLocation
    }
    type DefaultedRegistry_<T> = DefaultedRegistry<T>;
    class BlockFaceUV {
        constructor($$0: number[], $$1: number)
        getV($$0: number): number;
        getReverseIndex($$0: number): number;
        getU($$0: number): number;
        setMissingUv($$0: number[]): void;
        set missingUv($$0: number[])
        readonly rotation: number;
        uvs: number[];
    }
    type BlockFaceUV_ = BlockFaceUV;
    class Entity$RemovalReason extends Internal.Enum<Internal.Entity$RemovalReason> {
        static values(): Internal.Entity$RemovalReason[];
        shouldSave(): boolean;
        shouldDestroy(): boolean;
        static valueOf($$0: string): Internal.Entity$RemovalReason;
        static readonly CHANGED_DIMENSION: Internal.Entity$RemovalReason;
        static readonly UNLOADED_TO_CHUNK: Internal.Entity$RemovalReason;
        static readonly UNLOADED_WITH_PLAYER: Internal.Entity$RemovalReason;
        static readonly KILLED: Internal.Entity$RemovalReason;
        static readonly DISCARDED: Internal.Entity$RemovalReason;
    }
    type Entity$RemovalReason_ = "changed_dimension" | Entity$RemovalReason | "killed" | "discarded" | "unloaded_with_player" | "unloaded_to_chunk";
    class BlockFamily {
        getRecipeUnlockedBy(): Internal.Optional<string>;
        getRecipeGroupPrefix(): Internal.Optional<string>;
        get($$0: Internal.BlockFamily$Variant_): Internal.Block;
        shouldGenerateModel(): boolean;
        getBaseBlock(): Internal.Block;
        getVariants(): Internal.Map<Internal.BlockFamily$Variant, Internal.Block>;
        shouldGenerateRecipe($$0: Internal.FeatureFlagSet_): boolean;
        get recipeUnlockedBy(): Internal.Optional<string>
        get recipeGroupPrefix(): Internal.Optional<string>
        get baseBlock(): Internal.Block
        get variants(): Internal.Map<Internal.BlockFamily$Variant, Internal.Block>
    }
    type BlockFamily_ = BlockFamily;
    class ItemLichStaff extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemLichStaff_ = ItemLichStaff;
    class ServerActivityList extends Internal.ValueObject {
        constructor()
        static parse($$0: string): Internal.ServerActivityList;
        periodInMillis: number;
        serverActivities: Internal.List<Internal.ServerActivity>;
    }
    type ServerActivityList_ = ServerActivityList;
    class TridentItem extends Internal.Item implements Internal.Vanishable, Internal.ModifiableItemKJS {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly BASE_DAMAGE: 8.0;
        static readonly THROW_THRESHOLD_TIME: 10;
        static readonly SHOOT_POWER: 2.5;
        defaultModifiers: Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
    }
    type TridentItem_ = TridentItem;
    class ServerboundSelectTradePacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getItem(): number;
        isSkippable(): boolean;
        get item(): number
        get skippable(): boolean
    }
    type ServerboundSelectTradePacket_ = ServerboundSelectTradePacket;
    interface WindowKJS {
        kjs$loadIcons(original: Internal.List_<Internal.IoSupplier<Internal.InputStream>>): Internal.List<Internal.IoSupplier<Internal.InputStream>>;
    }
    type WindowKJS_ = WindowKJS;
    class DoubleWaterPlantBlock extends Internal.DoublePlantBlock implements Internal.SimpleWaterloggedBlock, Internal.BonemealableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        isBonemealSuccess(level: Internal.Level_, randomSource: Internal.RandomSource_, blockPos: BlockPos_, blockState: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal(serverLevel: Internal.ServerLevel_, randomSource: Internal.RandomSource_, blockPos: BlockPos_, blockState: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget(levelReader: Internal.LevelReader_, blockPos: BlockPos_, blockState: Internal.BlockState_, b: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type DoubleWaterPlantBlock_ = DoubleWaterPlantBlock;
}
declare namespace dev.tr7zw.skinlayers.accessor {
    interface NativeImageAccessor {
        abstract skinlayers$isAllocated(): boolean;
        (): boolean;
    }
    type NativeImageAccessor_ = NativeImageAccessor;
}
declare namespace net.darkhax.bookshelf.api.commands.args {
    class SingletonArgumentInfo <T extends Internal.ArgumentType<any>> implements Internal.ArgumentTypeInfo<T, net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo$Template<T>> {
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        unpack(template: T): net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo$Template<T>;
        serializeToNetwork(tTemplate: net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo$Template_<T>, friendlyByteBuf: Internal.FriendlyByteBuf_): void;
        deserializeFromNetwork(buffer: Internal.FriendlyByteBuf_): net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo$Template<T>;
        serializeToJson(tTemplate: net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo$Template_<T>, jsonObject: Internal.JsonObject_): void;
        static of<T extends Internal.ArgumentType<any>>(argSupplier: Internal.Supplier_<T>): net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo<T>;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        static of<T extends Internal.ArgumentType<any>>(argSupplier: T): net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo<T>;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
    }
    type SingletonArgumentInfo_<T extends Internal.ArgumentType<any>> = SingletonArgumentInfo<T>;
}
